/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ObjectNode
extends ContainerNode<ObjectNode> {
    private static final Joiner JOINER = Joiner.on((char)',');
    private final Map<String, JsonNode> members = Maps.newHashMap();

    public ObjectNode(JsonNodeFactory nc) {
        super(nc);
    }

    public ObjectNode deepCopy() {
        ObjectNode ret = new ObjectNode(this._nodeFactory);
        for (Map.Entry<String, JsonNode> entry : this.members.entrySet()) {
            ret.members.put(entry.getKey(), entry.getValue().deepCopy());
        }
        return ret;
    }

    public Map<String, JsonNode> asMap() {
        return Maps.newHashMap(this.members);
    }

    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    public boolean isObject() {
        return true;
    }

    public int size() {
        return this.members.size();
    }

    public Iterator<JsonNode> elements() {
        return this.members.values().iterator();
    }

    public JsonNode get(int index) {
        return null;
    }

    public JsonNode get(String fieldName) {
        return this.members.get(fieldName);
    }

    public Iterator<String> fieldNames() {
        return this.members.keySet().iterator();
    }

    public JsonNode path(int index) {
        return MissingNode.getInstance();
    }

    public JsonNode path(String fieldName) {
        JsonNode ret = this.members.get(fieldName);
        return ret == null ? MissingNode.getInstance() : ret;
    }

    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this.members.entrySet().iterator();
    }

    public ObjectNode with(String propertyName) {
        JsonNode n = this.members.get(propertyName);
        if (n != null) {
            if (n instanceof ObjectNode) {
                return (ObjectNode)n;
            }
            throw new UnsupportedOperationException("Property '" + propertyName + "' has value that is not of type ObjectNode (but " + n.getClass().getName() + ")");
        }
        ObjectNode result = this.objectNode();
        this.members.put(propertyName, (JsonNode)result);
        return result;
    }

    public ArrayNode withArray(String propertyName) {
        JsonNode n = this.members.get(propertyName);
        if (n != null) {
            if (n instanceof ArrayNode) {
                return (ArrayNode)n;
            }
            throw new UnsupportedOperationException("Property '" + propertyName + "' has value that is not of type ArrayNode (but " + n.getClass().getName() + ")");
        }
        ArrayNode result = this.arrayNode();
        this.members.put(propertyName, (JsonNode)result);
        return result;
    }

    public JsonNode findValue(String fieldName) {
        for (Map.Entry<String, JsonNode> entry : this.members.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                return entry.getValue();
            }
            JsonNode value = entry.getValue().findValue(fieldName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public List<JsonNode> findValues(String fieldName, List<JsonNode> foundSoFar) {
        for (Map.Entry<String, JsonNode> entry : this.members.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                if (foundSoFar == null) {
                    foundSoFar = new ArrayList<JsonNode>();
                }
                foundSoFar.add((JsonNode)entry.getValue());
                continue;
            }
            foundSoFar = entry.getValue().findValues(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    public List<String> findValuesAsText(String fieldName, List<String> foundSoFar) {
        for (Map.Entry<String, JsonNode> entry : this.members.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                if (foundSoFar == null) {
                    foundSoFar = new ArrayList<String>();
                }
                foundSoFar.add(entry.getValue().asText());
                continue;
            }
            foundSoFar = entry.getValue().findValuesAsText(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    public ObjectNode findParent(String fieldName) {
        for (Map.Entry<String, JsonNode> entry : this.members.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                return this;
            }
            JsonNode value = entry.getValue().findParent(fieldName);
            if (value == null) continue;
            return (ObjectNode)value;
        }
        return null;
    }

    public List<JsonNode> findParents(String fieldName, List<JsonNode> foundSoFar) {
        for (Map.Entry<String, JsonNode> entry : this.members.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                if (foundSoFar == null) {
                    foundSoFar = new ArrayList<JsonNode>();
                }
                foundSoFar.add((JsonNode)this);
                continue;
            }
            foundSoFar = entry.getValue().findParents(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        for (Map.Entry<String, JsonNode> en : this.members.entrySet()) {
            jgen.writeFieldName(en.getKey());
            ((JsonSerializable)en.getValue()).serialize(jgen, provider);
        }
        jgen.writeEndObject();
    }

    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)this, jgen);
        for (Map.Entry<String, JsonNode> en : this.members.entrySet()) {
            jgen.writeFieldName(en.getKey());
            ((JsonSerializable)en.getValue()).serialize(jgen, provider);
        }
        typeSer.writeTypeSuffixForObject((Object)this, jgen);
    }

    public JsonNode set(String fieldName, JsonNode value) {
        this.members.put(fieldName, (JsonNode)(value == null ? this.nullNode() : value));
        return this;
    }

    public JsonNode setAll(Map<String, JsonNode> properties) {
        for (Map.Entry<String, JsonNode> en : properties.entrySet()) {
            JsonNode node = en.getValue();
            if (node == null) {
                node = this.nullNode();
            }
            this.members.put(en.getKey(), node);
        }
        return this;
    }

    public JsonNode setAll(ObjectNode other) {
        this.members.putAll(other.members);
        return this;
    }

    public JsonNode replace(String fieldName, JsonNode value) {
        return this.members.put(fieldName, (JsonNode)(value == null ? this.nullNode() : value));
    }

    public JsonNode without(String fieldName) {
        this.members.remove(fieldName);
        return this;
    }

    public ObjectNode without(Collection<String> fieldNames) {
        this.members.keySet().removeAll(fieldNames);
        return this;
    }

    public JsonNode put(String fieldName, JsonNode value) {
        return this.members.put(fieldName, (JsonNode)(value == null ? this.nullNode() : value));
    }

    public JsonNode remove(String fieldName) {
        return this.members.remove(fieldName);
    }

    public ObjectNode remove(Collection<String> fieldNames) {
        this.members.keySet().removeAll(fieldNames);
        return this;
    }

    public ObjectNode removeAll() {
        this.members.clear();
        return this;
    }

    public JsonNode putAll(Map<String, JsonNode> properties) {
        return this.setAll(properties);
    }

    public JsonNode putAll(ObjectNode other) {
        return this.setAll(other);
    }

    public ObjectNode retain(Collection<String> fieldNames) {
        this.members.keySet().retainAll(fieldNames);
        return this;
    }

    public ObjectNode retain(String ... fieldNames) {
        return this.retain(Arrays.asList(fieldNames));
    }

    public ArrayNode putArray(String fieldName) {
        ArrayNode n = this.arrayNode();
        this.members.put(fieldName, (JsonNode)n);
        return n;
    }

    public ObjectNode putObject(String fieldName) {
        ObjectNode n = this.objectNode();
        this.members.put(fieldName, (JsonNode)n);
        return n;
    }

    public ObjectNode putPOJO(String fieldName, Object pojo) {
        this.members.put(fieldName, (JsonNode)this.POJONode(pojo));
        return this;
    }

    public ObjectNode putNull(String fieldName) {
        this.members.put(fieldName, (JsonNode)this.nullNode());
        return this;
    }

    public ObjectNode put(String fieldName, int v) {
        this.members.put(fieldName, (JsonNode)this.numberNode(v));
        return this;
    }

    public ObjectNode put(String fieldName, Integer value) {
        this.members.put(fieldName, (JsonNode)(value == null ? this.nullNode() : this.numberNode(value)));
        return this;
    }

    public ObjectNode put(String fieldName, long v) {
        this.members.put(fieldName, (JsonNode)this.numberNode(v));
        return this;
    }

    public ObjectNode put(String fieldName, Long value) {
        this.members.put(fieldName, (JsonNode)(value == null ? this.nullNode() : this.numberNode(value)));
        return this;
    }

    public ObjectNode put(String fieldName, float v) {
        this.members.put(fieldName, (JsonNode)this.numberNode(v));
        return this;
    }

    public ObjectNode put(String fieldName, Float value) {
        this.members.put(fieldName, (JsonNode)(value == null ? this.nullNode() : this.numberNode(value.floatValue())));
        return this;
    }

    public ObjectNode put(String fieldName, double v) {
        this.members.put(fieldName, (JsonNode)this.numberNode(v));
        return this;
    }

    public ObjectNode put(String fieldName, Double value) {
        this.members.put(fieldName, (JsonNode)(value == null ? this.nullNode() : this.numberNode(value)));
        return this;
    }

    public ObjectNode put(String fieldName, BigDecimal v) {
        this.members.put(fieldName, (JsonNode)(v == null ? this.nullNode() : this.numberNode(v)));
        return this;
    }

    public ObjectNode put(String fieldName, String v) {
        this.members.put(fieldName, (JsonNode)(v == null ? this.nullNode() : this.textNode(v)));
        return this;
    }

    public ObjectNode put(String fieldName, boolean v) {
        this.members.put(fieldName, (JsonNode)this.booleanNode(v));
        return this;
    }

    public ObjectNode put(String fieldName, Boolean value) {
        this.members.put(fieldName, (JsonNode)(value == null ? this.nullNode() : this.booleanNode(value)));
        return this;
    }

    public ObjectNode put(String fieldName, byte[] v) {
        this.members.put(fieldName, (JsonNode)(v == null ? this.nullNode() : this.binaryNode(v)));
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ObjectNode other = (ObjectNode)((Object)o);
        return this.members.equals(other.members);
    }

    public int hashCode() {
        return this.members.hashCode();
    }

    public String toString() {
        HashSet set = Sets.newHashSetWithExpectedSize((int)this.members.size());
        for (Map.Entry<String, JsonNode> entry : this.members.entrySet()) {
            set.add(ObjectNode.entryToString(entry));
        }
        return '{' + JOINER.join((Iterable)set) + '}';
    }

    private static String entryToString(Map.Entry<String, JsonNode> entry) {
        StringBuilder sb = new StringBuilder();
        TextNode.appendQuoted((StringBuilder)sb, (String)entry.getKey());
        return sb.append(':').append(entry.getValue()).toString();
    }
}

