/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ArrayNode
extends ContainerNode<ArrayNode> {
    private static final Joiner JOINER = Joiner.on((char)',');
    private final List<JsonNode> elements = Lists.newArrayList();

    public ArrayNode(JsonNodeFactory nc) {
        super(nc);
    }

    public ArrayNode deepCopy() {
        ArrayNode ret = new ArrayNode(this._nodeFactory);
        for (JsonNode element : this.elements) {
            ret.elements.add(element.deepCopy());
        }
        return ret;
    }

    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    public boolean isArray() {
        return true;
    }

    public int size() {
        return this.elements.size();
    }

    public Iterator<JsonNode> elements() {
        return this.elements.iterator();
    }

    public JsonNode get(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.elements.size()) {
            return null;
        }
        return this.elements.get(index);
    }

    public JsonNode get(String fieldName) {
        return null;
    }

    public JsonNode path(String fieldName) {
        return MissingNode.getInstance();
    }

    public JsonNode path(int index) {
        if (index < 0) {
            return MissingNode.getInstance();
        }
        if (index >= this.elements.size()) {
            return MissingNode.getInstance();
        }
        return this.elements.get(index);
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        for (JsonNode n : this.elements) {
            ((JsonSerializable)n).serialize(jgen, provider);
        }
        jgen.writeEndArray();
    }

    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForArray((Object)this, jgen);
        for (JsonNode n : this.elements) {
            ((JsonSerializable)n).serialize(jgen, provider);
        }
        typeSer.writeTypeSuffixForArray((Object)this, jgen);
    }

    public JsonNode findValue(String fieldName) {
        for (JsonNode node : this.elements) {
            JsonNode value = node.findValue(fieldName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public List<JsonNode> findValues(String fieldName, List<JsonNode> foundSoFar) {
        for (JsonNode node : this.elements) {
            foundSoFar = node.findValues(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    public List<String> findValuesAsText(String fieldName, List<String> foundSoFar) {
        for (JsonNode node : this.elements) {
            foundSoFar = node.findValuesAsText(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    public ObjectNode findParent(String fieldName) {
        for (JsonNode node : this.elements) {
            JsonNode parent = node.findParent(fieldName);
            if (parent == null) continue;
            return (ObjectNode)parent;
        }
        return null;
    }

    public List<JsonNode> findParents(String fieldName, List<JsonNode> foundSoFar) {
        for (JsonNode node : this.elements) {
            foundSoFar = node.findParents(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    public JsonNode set(int index, JsonNode value) {
        return this._set(index, (JsonNode)(value == null ? this.nullNode() : value));
    }

    public ArrayNode add(JsonNode value) {
        JsonNode node = value == null ? this.nullNode() : value;
        this.elements.add(node);
        return this;
    }

    public ArrayNode addAll(ArrayNode other) {
        this.elements.addAll(other.elements);
        return this;
    }

    public ArrayNode addAll(Collection<JsonNode> nodes) {
        this.elements.addAll(nodes);
        return this;
    }

    public ArrayNode insert(int index, JsonNode value) {
        this.doInsert(index, (JsonNode)(value == null ? this.nullNode() : value));
        return this;
    }

    public JsonNode remove(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.elements.size()) {
            return null;
        }
        return this.elements.remove(index);
    }

    public ArrayNode removeAll() {
        this.elements.clear();
        return this;
    }

    public ArrayNode addArray() {
        ArrayNode n = this.arrayNode();
        this.elements.add((JsonNode)n);
        return n;
    }

    public ObjectNode addObject() {
        ObjectNode n = this.objectNode();
        this.elements.add((JsonNode)n);
        return n;
    }

    public ArrayNode addPOJO(Object value) {
        this.elements.add((JsonNode)(value == null ? this.nullNode() : this.POJONode(value)));
        return this;
    }

    public ArrayNode addNull() {
        this.elements.add((JsonNode)this.nullNode());
        return this;
    }

    public ArrayNode add(int v) {
        this.elements.add((JsonNode)this.numberNode(v));
        return this;
    }

    public ArrayNode add(Integer value) {
        this.elements.add((JsonNode)(value == null ? this.nullNode() : this.numberNode(value)));
        return this;
    }

    public ArrayNode add(long v) {
        this.elements.add((JsonNode)this.numberNode(v));
        return this;
    }

    public ArrayNode add(Long value) {
        this.elements.add((JsonNode)(value == null ? this.nullNode() : this.numberNode(value)));
        return this;
    }

    public ArrayNode add(float v) {
        this.elements.add((JsonNode)this.numberNode(v));
        return this;
    }

    public ArrayNode add(Float value) {
        this.elements.add((JsonNode)(value == null ? this.nullNode() : this.numberNode(value.floatValue())));
        return this;
    }

    public ArrayNode add(double v) {
        this.elements.add((JsonNode)this.numberNode(v));
        return this;
    }

    public ArrayNode add(Double value) {
        this.elements.add((JsonNode)(value == null ? this.nullNode() : this.numberNode(value)));
        return this;
    }

    public ArrayNode add(BigDecimal v) {
        this.elements.add((JsonNode)(v == null ? this.nullNode() : this.numberNode(v)));
        return this;
    }

    public ArrayNode add(String v) {
        this.elements.add((JsonNode)(v == null ? this.nullNode() : this.textNode(v)));
        return this;
    }

    public ArrayNode add(boolean v) {
        this.elements.add((JsonNode)this.booleanNode(v));
        return this;
    }

    public ArrayNode add(Boolean value) {
        this.elements.add((JsonNode)(value == null ? this.nullNode() : this.booleanNode(value)));
        return this;
    }

    public ArrayNode add(byte[] v) {
        this.elements.add((JsonNode)(v == null ? this.nullNode() : this.binaryNode(v)));
        return this;
    }

    public ArrayNode insertArray(int index) {
        ArrayNode n = this.arrayNode();
        this.doInsert(index, (JsonNode)n);
        return n;
    }

    public ObjectNode insertObject(int index) {
        ObjectNode n = this.objectNode();
        this.doInsert(index, (JsonNode)n);
        return n;
    }

    public ArrayNode insertPOJO(int index, Object value) {
        this.doInsert(index, (JsonNode)(value == null ? this.nullNode() : this.POJONode(value)));
        return this;
    }

    public ArrayNode insertNull(int index) {
        this.doInsert(index, (JsonNode)this.nullNode());
        return this;
    }

    public ArrayNode insert(int index, int v) {
        this.doInsert(index, (JsonNode)this.numberNode(v));
        return this;
    }

    public ArrayNode insert(int index, Integer value) {
        this.doInsert(index, (JsonNode)(value == null ? this.nullNode() : this.numberNode(value)));
        return this;
    }

    public ArrayNode insert(int index, long v) {
        this.doInsert(index, (JsonNode)this.numberNode(v));
        return this;
    }

    public ArrayNode insert(int index, Long value) {
        this.doInsert(index, (JsonNode)(value == null ? this.nullNode() : this.numberNode(value)));
        return this;
    }

    public ArrayNode insert(int index, float v) {
        this.doInsert(index, (JsonNode)this.numberNode(v));
        return this;
    }

    public ArrayNode insert(int index, Float value) {
        this.doInsert(index, (JsonNode)(value == null ? this.nullNode() : this.numberNode(value.floatValue())));
        return this;
    }

    public ArrayNode insert(int index, double v) {
        this.doInsert(index, (JsonNode)this.numberNode(v));
        return this;
    }

    public ArrayNode insert(int index, Double value) {
        this.doInsert(index, (JsonNode)(value == null ? this.nullNode() : this.numberNode(value)));
        return this;
    }

    public ArrayNode insert(int index, BigDecimal v) {
        this.doInsert(index, (JsonNode)(v == null ? this.nullNode() : this.numberNode(v)));
        return this;
    }

    public ArrayNode insert(int index, String v) {
        this.doInsert(index, (JsonNode)(v == null ? this.nullNode() : this.textNode(v)));
        return this;
    }

    public ArrayNode insert(int index, boolean v) {
        this.doInsert(index, (JsonNode)this.booleanNode(v));
        return this;
    }

    public ArrayNode insert(int index, Boolean value) {
        this.doInsert(index, (JsonNode)(value == null ? this.nullNode() : this.booleanNode(value)));
        return this;
    }

    public ArrayNode insert(int index, byte[] v) {
        this.doInsert(index, (JsonNode)(v == null ? this.nullNode() : this.binaryNode(v)));
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.elements.equals(((ArrayNode)((Object)o)).elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        return '[' + JOINER.join(this.elements) + ']';
    }

    private JsonNode _set(int index, JsonNode value) {
        if (index < 0 || index >= this.elements.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + index + ", array size " + this.size());
        }
        return this.elements.set(index, value);
    }

    private void doInsert(int index, JsonNode node) {
        if (index < 0) {
            this.elements.add(0, node);
        } else if (index >= this.elements.size()) {
            this.elements.add(node);
        } else {
            this.elements.add(index, node);
        }
    }
}

