/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.process;

import com.github.fge.grappa.transform.base.InstructionGraphNode;
import com.github.fge.grappa.transform.base.InstructionGroup;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.hash.InstructionGroupHasher;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class InstructionGroupPreparer
implements RuleMethodProcessor {
    private RuleMethod method;

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        return method.containsExplicitActions() || method.containsVars();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        this.method = Objects.requireNonNull(method, "method");
        for (InstructionGroup group : method.getGroups()) {
            this.extractInstructions(group);
            InstructionGroupPreparer.extractFields(group);
            InstructionGroupHasher.hash(group, classNode.name);
        }
    }

    private void extractInstructions(InstructionGroup group) {
        for (InstructionGraphNode node : group.getNodes()) {
            if (node == group.getRoot()) continue;
            AbstractInsnNode insn = node.getInstruction();
            this.method.instructions.remove(insn);
            group.getInstructions().add(insn);
        }
    }

    private static void extractFields(InstructionGroup group) {
        List<FieldNode> fields = group.getFields();
        for (InstructionGraphNode node : group.getNodes()) {
            int index;
            if (!node.isXLoad()) continue;
            VarInsnNode insn = (VarInsnNode)node.getInstruction();
            for (index = 0; index < fields.size() && fields.get((int)index).access != insn.var; ++index) {
            }
            if (index == fields.size()) {
                Type type = node.getResultValue().getType();
                fields.add(new FieldNode(insn.var, "field$" + index, type.getDescriptor(), null, (Object)type));
            }
            insn.var = index;
        }
    }
}

