/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.process;

import com.github.fge.grappa.exceptions.InvalidGrammarException;
import com.github.fge.grappa.misc.AsmUtils;
import com.github.fge.grappa.transform.ClassCache;
import com.github.fge.grappa.transform.base.InstructionGraphNode;
import com.github.fge.grappa.transform.base.InstructionGroup;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;

public final class InstructionGroupCreator
implements RuleMethodProcessor {
    private final Map<String, Integer> memberModifiers = new HashMap<String, Integer>();
    private RuleMethod method;

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        return method.containsExplicitActions() || method.containsVars();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        this.method = Objects.requireNonNull(method, "method");
        this.createGroups();
        for (InstructionGroup group : method.getGroups()) {
            this.sort(group);
            this.markUngroupedEnclosedNodes(group);
            this.verify(group);
        }
        for (InstructionGraphNode node : method.getGraphNodes()) {
            if (node.getGroup() != null) continue;
            this.verifyAccess(node);
        }
    }

    private void createGroups() {
        for (InstructionGraphNode node : this.method.getGraphNodes()) {
            if (!node.isActionRoot() && !node.isVarInitRoot()) continue;
            InstructionGroup group = new InstructionGroup(node);
            this.markGroup(node, group);
            this.method.getGroups().add(group);
        }
    }

    private void markGroup(InstructionGraphNode node, InstructionGroup group) {
        boolean condition;
        boolean bl = condition = node == group.getRoot() || !node.isActionRoot() && !node.isVarInitRoot();
        if (!condition) {
            throw new InvalidGrammarException("method " + this.method.name + " contains illegal nested ACTION/Var constructs");
        }
        if (node.getGroup() != null) {
            return;
        }
        node.setGroup(group);
        if (node.isXLoad()) {
            return;
        }
        if (!node.isVarInitRoot()) {
            for (InstructionGraphNode pred : node.getPredecessors()) {
                this.markGroup(pred, group);
            }
            return;
        }
        if (node.getPredecessors().size() != 2) {
            throw new InvalidGrammarException("FIXME: find error message");
        }
        this.markGroup(node.getPredecessors().get(1), group);
    }

    private void sort(InstructionGroup group) {
        MethodIndexComparator comparator = new MethodIndexComparator(this.method.instructions);
        Collections.sort(group.getNodes(), comparator);
    }

    private void markUngroupedEnclosedNodes(InstructionGroup group) {
        boolean keepGoing;
        do {
            keepGoing = false;
            List<InstructionGraphNode> graphNodes = this.method.getGraphNodes();
            int startIndex = this.getIndexOfFirstInsn(group);
            int endIndex = this.getIndexOfLastInsn(group);
            for (int i = startIndex; i < endIndex; ++i) {
                InstructionGraphNode node = graphNodes.get(i);
                if (node.getGroup() != null) continue;
                this.markGroup(node, group);
                this.sort(group);
                keepGoing = true;
            }
        } while (keepGoing);
    }

    private void verify(InstructionGroup group) {
        int i;
        int sizeMinus1;
        List<InstructionGraphNode> nodes = group.getNodes();
        Preconditions.checkState((nodes.get(sizeMinus1 = nodes.size() - 1) == group.getRoot() ? 1 : 0) != 0);
        for (i = 0; i < sizeMinus1; ++i) {
            InstructionGraphNode node = nodes.get(i);
            if (node.isXStore()) {
                throw new InvalidGrammarException("An action or Var initializer in method " + this.method.name + " contains an illegal write" + " to a local variable/parameter");
            }
            this.verifyAccess(node);
        }
        i = this.getIndexOfLastInsn(group) - this.getIndexOfFirstInsn(group);
        if (i == sizeMinus1) {
            return;
        }
        throw new InvalidGrammarException("error during bytecode analysis of rule method " + this.method.name + ": discontinuous group block");
    }

    private void verifyAccess(InstructionGraphNode node) {
        switch (node.getInstruction().getOpcode()) {
            case 178: 
            case 180: {
                FieldInsnNode field = (FieldInsnNode)node.getInstruction();
                if (!this.isPrivateField(field.owner, field.name)) break;
                throw new InvalidGrammarException("rule methods cannot access private fields (method: " + this.method.name + ", field: " + field.name + ')');
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MethodInsnNode calledMethod = (MethodInsnNode)node.getInstruction();
                if (!this.isPrivate(calledMethod.owner, calledMethod.name, calledMethod.desc)) break;
                throw new InvalidGrammarException("method " + this.method.name + " contains an illegal call to private method " + calledMethod.name + "; make the latter protected or" + " package private");
            }
        }
    }

    private int getIndexOfFirstInsn(InstructionGroup group) {
        return this.method.instructions.indexOf(group.getNodes().get(0).getInstruction());
    }

    private int getIndexOfLastInsn(InstructionGroup group) {
        List<InstructionGraphNode> graphNodes = group.getNodes();
        return this.method.instructions.indexOf(graphNodes.get(graphNodes.size() - 1).getInstruction());
    }

    private boolean isPrivateField(String owner, String name) {
        String key = owner + '#' + name;
        Integer modifiers = this.memberModifiers.get(key);
        if (modifiers == null) {
            modifiers = AsmUtils.getClassField(owner, name).getModifiers();
            this.memberModifiers.put(key, modifiers);
        }
        return Modifier.isPrivate(modifiers);
    }

    private boolean isPrivate(String owner, String name, String desc) {
        return "<init>".equals(name) ? this.isPrivateInstantiation(owner, desc) : this.isPrivateMethod(owner, name, desc);
    }

    private boolean isPrivateMethod(String owner, String name, String desc) {
        String key = owner + '#' + name + '#' + desc;
        Integer modifiers = this.memberModifiers.get(key);
        if (modifiers == null) {
            modifiers = AsmUtils.getClassMethod(owner, name, desc).getModifiers();
            this.memberModifiers.put(key, modifiers);
        }
        return Modifier.isPrivate(modifiers);
    }

    private boolean isPrivateInstantiation(String owner, String desc) {
        Integer modifiers = this.memberModifiers.get(owner);
        if (modifiers == null) {
            modifiers = ClassCache.INSTANCE.loadClass(owner).getModifiers();
            this.memberModifiers.put(owner, modifiers);
        }
        if (Modifier.isPrivate(modifiers)) {
            return true;
        }
        String key = owner + "#<init>#" + desc;
        modifiers = this.memberModifiers.get(key);
        if (modifiers == null) {
            modifiers = AsmUtils.getClassConstructor(owner, desc).getModifiers();
            this.memberModifiers.put(key, modifiers);
        }
        return Modifier.isPrivate(modifiers);
    }

    private static final class MethodIndexComparator
    implements Comparator<InstructionGraphNode> {
        private final InsnList instructions;

        private MethodIndexComparator(@Nonnull InsnList instructions) {
            this.instructions = Objects.requireNonNull(instructions);
        }

        @Override
        public int compare(InstructionGraphNode o1, InstructionGraphNode o2) {
            int i1 = this.instructions.indexOf(o1.getInstruction());
            int i2 = this.instructions.indexOf(o2.getInstruction());
            return Integer.compare(i1, i2);
        }
    }
}

