/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.process;

import com.github.fge.grappa.misc.AsmUtils;
import com.github.fge.grappa.run.context.Context;
import com.github.fge.grappa.run.context.ContextAware;
import com.github.fge.grappa.transform.CodeBlock;
import com.github.fge.grappa.transform.base.InstructionGraphNode;
import com.github.fge.grappa.transform.base.InstructionGroup;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class GroupClassGenerator
implements RuleMethodProcessor {
    private final boolean forceCodeBuilding;
    protected ParserClassNode classNode;
    protected RuleMethod method;

    protected GroupClassGenerator(boolean forceCodeBuilding) {
        this.forceCodeBuilding = forceCodeBuilding;
    }

    @Override
    public final void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        this.classNode = Objects.requireNonNull(classNode, "classNode");
        this.method = Objects.requireNonNull(method, "method");
        for (InstructionGroup group : method.getGroups()) {
            if (!this.appliesTo(group.getRoot())) continue;
            this.loadGroupClass(group);
        }
    }

    protected abstract boolean appliesTo(InstructionGraphNode var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGroupClass(InstructionGroup group) {
        this.createGroupClassType(group);
        String className = group.getGroupClassType().getClassName();
        ClassLoader classLoader = this.classNode.getParentClass().getClassLoader();
        Class<AsmUtils> clazz = AsmUtils.class;
        synchronized (AsmUtils.class) {
            Class<?> groupClass = AsmUtils.findLoadedClass(className, classLoader);
            if (groupClass == null || this.forceCodeBuilding) {
                byte[] groupClassCode = this.generateGroupClassCode(group);
                group.setGroupClassCode(groupClassCode);
                if (groupClass == null) {
                    AsmUtils.loadClass(className, groupClassCode, classLoader);
                }
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    private void createGroupClassType(InstructionGroup group) {
        String s = this.classNode.name;
        int lastSlash = this.classNode.name.lastIndexOf(47);
        String groupName = group.getName();
        String pkg = lastSlash >= 0 ? s.substring(0, lastSlash) : s;
        String groupClassInternalName = pkg + '/' + groupName;
        group.setGroupClassType(Type.getObjectType((String)groupClassInternalName));
    }

    protected final byte[] generateGroupClassCode(InstructionGroup group) {
        ClassWriter classWriter = new ClassWriter(2);
        this.generateClassBasics(group, classWriter);
        GroupClassGenerator.generateFields(group, classWriter);
        this.generateConstructor(classWriter);
        this.generateMethod(group, classWriter);
        return classWriter.toByteArray();
    }

    private void generateClassBasics(InstructionGroup group, ClassWriter cw) {
        cw.visit(51, 4113, group.getGroupClassType().getInternalName(), null, this.getBaseType().getInternalName(), null);
        cw.visitSource(this.classNode.sourceFile, null);
    }

    protected abstract Type getBaseType();

    private static void generateFields(InstructionGroup group, ClassWriter cw) {
        for (FieldNode field : group.getFields()) {
            cw.visitField(4097, field.name, field.desc, null, null);
        }
    }

    private void generateConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{String.class}), null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, this.getBaseType().getInternalName(), "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{String.class}), false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    protected abstract void generateMethod(InstructionGroup var1, ClassWriter var2);

    protected static void insertSetContextCalls(InstructionGroup group, int localVarIx) {
        InsnList instructions = group.getInstructions();
        CodeBlock block = CodeBlock.newCodeBlock();
        for (InstructionGraphNode node : group.getNodes()) {
            if (!node.isCallOnContextAware()) continue;
            AbstractInsnNode insn = node.getInstruction();
            if (node.getPredecessors().size() > 1) {
                AbstractInsnNode loadTarget = node.getPredecessors().get(0).getInstruction();
                block.clear().dup().astore(++localVarIx);
                instructions.insert(loadTarget, block.getInstructionList());
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, localVarIx));
            } else {
                instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(89));
            }
            block.clear().aload(1).invokeinterface(CodegenUtils.p(ContextAware.class), "setContext", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{Context.class}));
            instructions.insertBefore(insn, block.getInstructionList());
        }
    }

    protected static void convertXLoads(InstructionGroup group) {
        String owner = group.getGroupClassType().getInternalName();
        for (InstructionGraphNode node : group.getNodes()) {
            if (!node.isXLoad()) continue;
            VarInsnNode insn = (VarInsnNode)node.getInstruction();
            FieldNode field = group.getFields().get(insn.var);
            FieldInsnNode fieldNode = new FieldInsnNode(180, owner, field.name, field.desc);
            InsnList insnList = group.getInstructions();
            insnList.insert((AbstractInsnNode)insn, (AbstractInsnNode)fieldNode);
            insnList.set((AbstractInsnNode)insn, (AbstractInsnNode)new VarInsnNode(25, 0));
        }
    }
}

