/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.process;

import com.github.fge.grappa.matchers.base.Matcher;
import com.github.fge.grappa.matchers.wrap.ProxyMatcher;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.transform.CodeBlock;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import com.github.fge.grappa.transform.runtime.CacheArguments;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;

public final class CachingGenerator
implements RuleMethodProcessor {
    private ParserClassNode classNode;
    private RuleMethod method;
    private InsnList instructions;
    private AbstractInsnNode retInsn;
    private String cacheFieldName;

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        return method.hasCachedAnnotation();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        Preconditions.checkState((!method.isSuperMethod() ? 1 : 0) != 0);
        this.classNode = classNode;
        this.method = method;
        this.instructions = method.instructions;
        this.retInsn = this.instructions.getLast();
        while (this.retInsn.getOpcode() != 176) {
            this.retInsn = this.retInsn.getPrevious();
        }
        CodeBlock block = CodeBlock.newCodeBlock();
        this.generateCacheHitReturn(block);
        this.generateStoreNewProxyMatcher(block);
        this.instructions.insert(block.getInstructionList());
        block = CodeBlock.newCodeBlock();
        CachingGenerator.generateArmProxyMatcher(block);
        this.generateStoreInCache(block);
        this.instructions.insertBefore(this.retInsn, block.getInstructionList());
    }

    private void generateCacheHitReturn(CodeBlock block) {
        this.generateGetFromCache(block);
        LabelNode cacheMiss = new LabelNode();
        block.dup().ifnull(cacheMiss).areturn().label(cacheMiss).pop();
    }

    private void generateGetFromCache(CodeBlock block) {
        Type[] paramTypes = Type.getArgumentTypes((String)this.method.desc);
        this.cacheFieldName = this.findUnusedCacheFieldName();
        String cacheFieldDesc = paramTypes.length == 0 ? CodegenUtils.ci(Rule.class) : CodegenUtils.ci(HashMap.class);
        FieldNode field = new FieldNode(2, this.cacheFieldName, cacheFieldDesc, null, null);
        this.classNode.fields.add(field);
        block.aload(0).getfield(this.classNode.name, this.cacheFieldName, cacheFieldDesc);
        if (paramTypes.length == 0) {
            return;
        }
        LabelNode alreadyInitialized = new LabelNode();
        block.dup().ifnonnull(alreadyInitialized).pop().aload(0).newobj(CodegenUtils.p(HashMap.class)).dup_x1().dup().invokespecial(CodegenUtils.p(HashMap.class), "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[0])).putfield(this.classNode.name, this.cacheFieldName, cacheFieldDesc).label(alreadyInitialized);
        if (paramTypes.length > 1 || paramTypes[0].getSort() == 9) {
            block.newobj(CodegenUtils.p(CacheArguments.class)).dup();
            this.generatePushNewParameterObjectArray(block, paramTypes);
            block.invokespecial(CodegenUtils.p(CacheArguments.class), "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{Object[].class}));
        } else {
            CachingGenerator.generatePushParameterAsObject(block, paramTypes, 0);
        }
        block.dup().astore(this.method.maxLocals).invokevirtual(CodegenUtils.p(HashMap.class), "get", CodegenUtils.sig(Object.class, (Class[])new Class[]{Object.class}));
    }

    private String findUnusedCacheFieldName() {
        String name = "cache$" + this.method.name;
        int i = 2;
        while (this.hasField(name)) {
            name = "cache$" + this.method.name + i++;
        }
        return name;
    }

    private boolean hasField(String fieldName) {
        for (Object field : this.classNode.fields) {
            if (!fieldName.equals(((FieldNode)field).name)) continue;
            return true;
        }
        return false;
    }

    private void generatePushNewParameterObjectArray(CodeBlock block, Type[] paramTypes) {
        block.bipush(paramTypes.length).anewarray(CodegenUtils.p(Object.class));
        for (int i = 0; i < paramTypes.length; ++i) {
            block.dup().bipush(i);
            CachingGenerator.generatePushParameterAsObject(block, paramTypes, i);
            block.aastore();
        }
    }

    private static void generatePushParameterAsObject(CodeBlock block, Type[] paramTypes, int parameterNr) {
        switch (paramTypes[parameterNr++].getSort()) {
            case 1: {
                block.iload(parameterNr).invokestatic(CodegenUtils.p(Boolean.class), "valueOf", CodegenUtils.sig(Boolean.class, (Class[])new Class[]{Boolean.TYPE}));
                return;
            }
            case 2: {
                block.iload(parameterNr).invokestatic(CodegenUtils.p(Character.class), "valueOf", CodegenUtils.sig(Character.class, (Class[])new Class[]{Character.TYPE}));
                return;
            }
            case 3: {
                block.iload(parameterNr).invokestatic(CodegenUtils.p(Byte.class), "valueOf", CodegenUtils.sig(Byte.class, (Class[])new Class[]{Byte.TYPE}));
                return;
            }
            case 4: {
                block.iload(parameterNr).invokestatic(CodegenUtils.p(Short.class), "valueOf", CodegenUtils.sig(Short.class, (Class[])new Class[]{Short.TYPE}));
                return;
            }
            case 5: {
                block.iload(parameterNr).invokestatic(CodegenUtils.p(Integer.class), "valueOf", CodegenUtils.sig(Integer.class, (Class[])new Class[]{Integer.TYPE}));
                return;
            }
            case 6: {
                block.fload(parameterNr).invokestatic(CodegenUtils.p(Float.class), "valueOf", CodegenUtils.sig(Float.class, (Class[])new Class[]{Float.TYPE}));
                return;
            }
            case 7: {
                block.lload(parameterNr).invokestatic(CodegenUtils.p(Long.class), "valueOf", CodegenUtils.sig(Long.class, (Class[])new Class[]{Long.TYPE}));
                return;
            }
            case 8: {
                block.dload(parameterNr).invokestatic(CodegenUtils.p(Double.class), "valueOf", CodegenUtils.sig(Double.class, (Class[])new Class[]{Double.TYPE}));
                return;
            }
            case 9: 
            case 10: {
                block.aload(parameterNr);
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void generateStoreNewProxyMatcher(CodeBlock block) {
        block.newobj(CodegenUtils.p(ProxyMatcher.class)).dup().invokespecial(CodegenUtils.p(ProxyMatcher.class), "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[0]));
        this.generateStoreInCache(block);
    }

    private static void generateArmProxyMatcher(CodeBlock block) {
        block.dup_x1().checkcast(CodegenUtils.p(Matcher.class)).invokevirtual(CodegenUtils.p(ProxyMatcher.class), "arm", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{Matcher.class}));
    }

    private void generateStoreInCache(CodeBlock block) {
        Type[] paramTypes = Type.getArgumentTypes((String)this.method.desc);
        block.dup();
        if (paramTypes.length == 0) {
            block.aload(0).swap().putfield(this.classNode.name, this.cacheFieldName, CodegenUtils.ci(Rule.class));
            return;
        }
        block.aload(this.method.maxLocals).swap().aload(0).getfield(this.classNode.name, this.cacheFieldName, CodegenUtils.ci(HashMap.class)).dup_x2().pop().invokevirtual(CodegenUtils.p(HashMap.class), "put", CodegenUtils.sig(Object.class, (Class[])new Class[]{Object.class, Object.class})).pop();
    }
}

