/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.generate;

import com.github.fge.grappa.exceptions.InvalidGrammarException;
import com.github.fge.grappa.misc.AsmUtils;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.transform.ParserAnnotation;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public final class ClassNodeInitializer
extends ClassVisitor {
    private static final Set<ParserAnnotation> CLASS_FLAGS_CLEAR = EnumSet.of(ParserAnnotation.EXPLICIT_ACTIONS_ONLY, ParserAnnotation.DONT_LABEL, ParserAnnotation.SKIP_ACTIONS_IN_PREDICATES);
    private ParserClassNode classNode;
    private Class<?> ownerClass;
    private final Set<ParserAnnotation> annotations = EnumSet.noneOf(ParserAnnotation.class);

    public ClassNodeInitializer() {
        super(327680);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ParserClassNode classNode) throws IOException {
        this.classNode = Objects.requireNonNull(classNode, "classNode");
        this.ownerClass = classNode.getParentClass();
        while (!Object.class.equals(this.ownerClass)) {
            this.annotations.removeAll(CLASS_FLAGS_CLEAR);
            try (Closer closer = Closer.create();){
                InputStream in = ClassNodeInitializer.getInputStream(this.ownerClass);
                if (in == null) {
                    throw new IOException(this.ownerClass + " not found");
                }
                ClassReader reader = new ClassReader((InputStream)closer.register((Closeable)in));
                reader.accept((ClassVisitor)this, 4);
            }
            this.ownerClass = this.ownerClass.getSuperclass();
        }
        for (RuleMethod method : classNode.getRuleMethods().values()) {
            if (!method.isSuperMethod()) continue;
            String overridingMethodName = method.name.substring(1) + method.desc;
            RuleMethod overridingMethod = classNode.getRuleMethods().get(overridingMethodName);
            method.moveFlagsTo(overridingMethod);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.ownerClass == this.classNode.getParentClass()) {
            if ((access & 2) != 0) {
                throw new InvalidGrammarException("a parser class cannot be private");
            }
            if ((access & 0x10) != 0) {
                throw new InvalidGrammarException("a parser class cannot be final");
            }
            String className = AsmUtils.getExtendedParserClassName(name);
            this.classNode.visit(51, 1, className, null, this.classNode.getParentType().getInternalName(), null);
        }
    }

    @Nullable
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (ParserAnnotation.recordAnnotation(this.annotations, desc)) {
            return null;
        }
        if (!visible) {
            return null;
        }
        return this.ownerClass == this.classNode.getParentClass() ? this.classNode.visitAnnotation(desc, true) : null;
    }

    public void visitSource(String source, String debug) {
        this.classNode.visitSource(null, null);
    }

    @Nullable
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            if (this.ownerClass != this.classNode.getParentClass()) {
                return null;
            }
            if ((access & 2) > 0) {
                return null;
            }
            MethodNode constructor = new MethodNode(access, name, desc, signature, exceptions);
            this.classNode.getConstructors().add(constructor);
            return constructor;
        }
        if (!Type.getReturnType((String)desc).equals((Object)Type.getType(Rule.class))) {
            return null;
        }
        if ((access & 0x500) > 0) {
            return null;
        }
        if ((access & 2) != 0) {
            throw new InvalidGrammarException("rule methods cannot be private");
        }
        if ((access & 0x10) != 0) {
            throw new InvalidGrammarException("rule methods cannot be final");
        }
        String methodKey = name + desc;
        while (this.classNode.getRuleMethods().containsKey(methodKey)) {
            name = '$' + name;
            methodKey = name + desc;
        }
        RuleMethod method = new RuleMethod(this.ownerClass, access, name, desc, signature, exceptions, this.annotations);
        this.classNode.getRuleMethods().put(methodKey, method);
        return method;
    }

    public void visitEnd() {
        this.classNode.visitEnd();
    }

    private static InputStream getInputStream(Class<?> c) {
        Objects.requireNonNull(c);
        String name = c.getName().replace('.', '/') + ".class";
        ClassLoader me = ClassNodeInitializer.class.getClassLoader();
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        ClassLoader system = ClassLoader.getSystemClassLoader();
        InputStream ret = me.getResourceAsStream(name);
        if (ret == null) {
            ret = context.getResourceAsStream(name);
        }
        if (ret == null) {
            ret = system.getResourceAsStream(name);
        }
        if (ret == null) {
            throw new IllegalStateException("unable to load parser class??");
        }
        return ret;
    }
}

