/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform;

import com.github.fge.grappa.misc.AsmUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Array;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.objectweb.asm.Type;

public final class ClassCache {
    public static final ClassCache INSTANCE = new ClassCache();
    private final LoadingCache<String, Class<?>> cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)ClassCacheLoader.access$000());

    private ClassCache() {
    }

    public Class<?> loadClass(String className) {
        return (Class)this.cache.getUnchecked((Object)className);
    }

    @Nonnull
    public String toString() {
        return this.cache.stats().toString();
    }

    @ParametersAreNonnullByDefault
    private static final class ClassCacheLoader
    extends CacheLoader<String, Class<?>> {
        private static final ClassCacheLoader LOADER = new ClassCacheLoader();

        private ClassCacheLoader() {
        }

        public Class<?> load(String key) throws ClassNotFoundException {
            if (key.startsWith("[")) {
                String elementName = key.substring(1);
                Type type = Type.getType((String)elementName);
                Class<?> c = AsmUtils.getClassForType(type);
                return Array.newInstance(c, 0).getClass();
            }
            String name = key.replace('/', '.');
            ClassLoader cl = ClassCacheLoader.class.getClassLoader();
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException ignored) {
                cl = Thread.currentThread().getContextClassLoader();
                return cl.loadClass(name);
            }
        }

        static /* synthetic */ ClassCacheLoader access$000() {
            return LOADER;
        }
    }
}

