/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.stack;

import com.github.fge.grappa.stack.ValueStackBase;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class DefaultValueStack<V>
extends ValueStackBase<V> {
    private List<V> stack = new ArrayList<V>();

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public void clear() {
        this.stack.clear();
    }

    @Override
    @Nonnull
    public Object takeSnapshot() {
        return new ArrayList<V>(this.stack);
    }

    @Override
    public void restoreSnapshot(Object snapshot) {
        Objects.requireNonNull(snapshot);
        Preconditions.checkState((snapshot.getClass() == ArrayList.class ? 1 : 0) != 0);
        this.stack = (List)snapshot;
    }

    @Override
    protected void doPush(int down, V value) {
        this.stack.add(down, value);
    }

    @Override
    @Nonnull
    protected V doPop(int down) {
        return this.stack.remove(down);
    }

    @Override
    @Nonnull
    protected V doPeek(int down) {
        return this.stack.get(down);
    }

    @Override
    protected void doPoke(int down, V value) {
        this.stack.set(down, value);
    }

    @Override
    protected void doDup() {
        V element = this.stack.get(0);
        this.stack.add(0, element);
    }

    @Override
    protected void doSwap(int n) {
        Collections.reverse(this.stack.subList(0, n));
    }

    @Override
    public Iterator<V> iterator() {
        return Iterators.unmodifiableIterator(this.stack.iterator());
    }

    @Nonnull
    public String toString() {
        return this.stack.toString();
    }

    @Override
    protected void checkIndex(int index) {
        Preconditions.checkState((index < this.stack.size() ? 1 : 0) != 0, (Object)"not enough elements in stack");
    }
}

