/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.run.trace;

import com.github.fge.grappa.buffers.InputBuffer;
import com.github.fge.grappa.exceptions.GrappaException;
import com.github.fge.grappa.matchers.base.Matcher;
import com.github.fge.grappa.run.ParseRunnerListener;
import com.github.fge.grappa.run.context.MatcherContext;
import com.github.fge.grappa.run.events.MatchFailureEvent;
import com.github.fge.grappa.run.events.MatchSuccessEvent;
import com.github.fge.grappa.run.events.PostParseEvent;
import com.github.fge.grappa.run.events.PreMatchEvent;
import com.github.fge.grappa.run.events.PreParseEvent;
import com.github.fge.grappa.run.trace.MatcherDescriptor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class TracingListener<V>
extends ParseRunnerListener<V> {
    private static final Map<String, ?> ENV = Collections.singletonMap("create", "true");
    private static final String NODE_PATH = "/nodes.csv";
    private static final String MATCHERS_PATH = "/matchers.csv";
    private static final String INPUT_TEXT_PATH = "/input.txt";
    private static final String INFO_PATH = "/info.csv";
    private InputBuffer inputBuffer = null;
    private long startTime = 0L;
    private int nrLines = 0;
    private int nrChars = 0;
    private int nrCodePoints = 0;
    private final Map<Matcher, MatcherDescriptor> matcherDescriptors = new IdentityHashMap<Matcher, MatcherDescriptor>();
    private final Map<Matcher, Integer> matcherIds = new IdentityHashMap<Matcher, Integer>();
    private int nextMatcherId = 0;
    private final Map<Integer, Integer> nodeIds = new HashMap<Integer, Integer>();
    private int nextNodeId = 0;
    private final Map<Integer, Integer> prematchMatcherIds = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> prematchIndices = new HashMap<Integer, Integer>();
    private final Map<Integer, Long> prematchTimes = new HashMap<Integer, Long>();
    private final Path zipPath;
    private final Path nodeFile;
    private final BufferedWriter writer;
    private final StringBuilder sb = new StringBuilder();

    public TracingListener(Path zipPath, boolean delete) throws IOException {
        this.zipPath = zipPath;
        if (delete) {
            Files.deleteIfExists(zipPath);
        }
        this.nodeFile = Files.createTempFile("nodes", ".csv", new FileAttribute[0]);
        this.writer = Files.newBufferedWriter(this.nodeFile, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    @Override
    public void beforeParse(PreParseEvent<V> event) {
        this.nodeIds.put(-1, -1);
        this.inputBuffer = event.getContext().getInputBuffer();
        this.nrChars = this.inputBuffer.length();
        this.nrLines = this.inputBuffer.getLineCount();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void beforeMatch(PreMatchEvent<V> event) {
        MatcherContext context = event.getContext();
        Matcher matcher = context.getMatcher();
        Integer id = this.matcherIds.get(matcher);
        if (id == null) {
            id = this.nextMatcherId;
            this.matcherIds.put(matcher, id);
            this.matcherDescriptors.put(matcher, new MatcherDescriptor(this.nextMatcherId, matcher));
            ++this.nextMatcherId;
        }
        int level = context.getLevel();
        this.nodeIds.put(level, this.nextNodeId);
        ++this.nextNodeId;
        this.prematchMatcherIds.put(level, id);
        int startIndex = Math.min(this.nrChars, context.getCurrentIndex());
        this.prematchIndices.put(level, startIndex);
        this.prematchTimes.put(level, System.nanoTime());
    }

    @Override
    public void matchSuccess(MatchSuccessEvent<V> event) {
        long endTime = System.nanoTime();
        MatcherContext context = event.getContext();
        int level = context.getLevel();
        Integer parentNodeId = this.nodeIds.get(level - 1);
        Integer nodeId = this.nodeIds.get(level);
        int startIndex = this.prematchIndices.get(level);
        int endIndex = Math.min(this.nrChars, context.getCurrentIndex());
        Integer matcherId = this.prematchMatcherIds.get(level);
        long time = endTime - this.prematchTimes.get(level);
        this.sb.setLength(0);
        this.sb.append(parentNodeId).append(';').append(nodeId).append(';').append(level).append(";1;").append(matcherId).append(';').append(startIndex).append(';').append(endIndex).append(';').append(time).append('\n');
        try {
            this.writer.append(this.sb);
        }
        catch (IOException e) {
            throw this.cleanup(e);
        }
    }

    @Override
    public void matchFailure(MatchFailureEvent<V> event) {
        long endTime = System.nanoTime();
        MatcherContext context = event.getContext();
        int level = context.getLevel();
        Integer parentNodeId = this.nodeIds.get(level - 1);
        Integer nodeId = this.nodeIds.get(level);
        int startIndex = this.prematchIndices.get(level);
        int endIndex = context.getCurrentIndex();
        Integer matcherId = this.prematchMatcherIds.get(level);
        long time = endTime - this.prematchTimes.get(level);
        this.sb.setLength(0);
        this.sb.append(parentNodeId).append(';').append(nodeId).append(';').append(level).append(";0;").append(matcherId).append(';').append(startIndex).append(';').append(endIndex).append(';').append(time).append('\n');
        try {
            this.writer.append(this.sb);
        }
        catch (IOException e) {
            throw this.cleanup(e);
        }
    }

    @Override
    public void afterParse(PostParseEvent<V> event) {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw this.cleanup(e);
        }
        URI uri = URI.create("jar:" + this.zipPath.toUri());
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, ENV);){
            Files.move(this.nodeFile, zipfs.getPath(NODE_PATH, new String[0]), new CopyOption[0]);
            this.copyInputText(zipfs);
            this.copyMatcherInfo(zipfs);
            this.copyParseInfo(zipfs);
        }
        catch (IOException e) {
            throw this.cleanup(e);
        }
    }

    private void copyInputText(FileSystem zipfs) throws IOException {
        Path path = zipfs.getPath(INPUT_TEXT_PATH, new String[0]);
        String s = this.inputBuffer.extract(0, this.nrChars);
        this.nrCodePoints = s.codePointCount(0, this.nrChars);
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(s);
            writer.flush();
        }
    }

    private void copyMatcherInfo(FileSystem zipfs) {
        Path path = zipfs.getPath(MATCHERS_PATH, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (MatcherDescriptor descriptor : this.matcherDescriptors.values()) {
                this.sb.setLength(0);
                this.sb.append(descriptor.getId()).append(';').append(descriptor.getClassName()).append(';').append((Object)descriptor.getType()).append(';').append(descriptor.getName()).append('\n');
                writer.append(this.sb);
            }
            writer.flush();
        }
        catch (IOException e) {
            throw this.cleanup(e);
        }
    }

    private void copyParseInfo(FileSystem zipfs) throws IOException {
        Path path = zipfs.getPath(INFO_PATH, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.sb.setLength(0);
            this.sb.append(this.startTime).append(';').append(this.prematchIndices.size()).append(';').append(this.nextMatcherId).append(';').append(this.nrLines).append(';').append(this.nrChars).append(';').append(this.nrCodePoints).append(';').append(this.nextNodeId).append('\n');
            writer.append(this.sb);
            writer.flush();
        }
    }

    private GrappaException cleanup(IOException e) {
        GrappaException ret = new GrappaException("failed to write event", e);
        try {
            this.writer.close();
        }
        catch (IOException e2) {
            ret.addSuppressed(e2);
        }
        try {
            Files.deleteIfExists(this.nodeFile);
        }
        catch (IOException e3) {
            ret.addSuppressed(e3);
        }
        return ret;
    }
}

