/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.run.context;

import com.github.fge.grappa.buffers.InputBuffer;
import com.github.fge.grappa.exceptions.GrappaException;
import com.github.fge.grappa.exceptions.InvalidGrammarException;
import com.github.fge.grappa.matchers.ActionMatcher;
import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.Matcher;
import com.github.fge.grappa.matchers.wrap.ProxyMatcher;
import com.github.fge.grappa.run.MatchHandler;
import com.github.fge.grappa.run.context.MatcherContext;
import com.github.fge.grappa.stack.ValueStack;
import com.github.fge.grappa.support.IndexRange;
import com.github.fge.grappa.support.Position;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DefaultMatcherContext<V>
implements MatcherContext<V> {
    private static final Joiner JOINER = Joiner.on((char)'/');
    private final InputBuffer inputBuffer;
    private final ValueStack<V> valueStack;
    private final MatchHandler matchHandler;
    private final DefaultMatcherContext<V> parent;
    private final int level;
    private DefaultMatcherContext<V> subContext;
    private int startIndex;
    private int currentIndex;
    private Matcher matcher;
    private String path;
    private boolean hasError;

    public DefaultMatcherContext(@Nonnull InputBuffer inputBuffer, @Nonnull ValueStack<V> valueStack, @Nonnull MatchHandler matchHandler, @Nonnull Matcher matcher) {
        this(Objects.requireNonNull(inputBuffer, "inputBuffer"), Objects.requireNonNull(valueStack, "valueStack"), Objects.requireNonNull(matchHandler, "matchHandler"), null, 0);
        Objects.requireNonNull(matcher);
        this.matcher = ProxyMatcher.unwrap(matcher);
    }

    private DefaultMatcherContext(InputBuffer inputBuffer, ValueStack<V> valueStack, MatchHandler matchHandler, @Nullable DefaultMatcherContext<V> parent, int level) {
        this.inputBuffer = inputBuffer;
        this.valueStack = valueStack;
        this.matchHandler = matchHandler;
        this.parent = parent;
        this.level = level;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public MatcherContext<V> getParent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public Matcher getMatcher() {
        return this.matcher;
    }

    @Override
    public char getCurrentChar() {
        return this.inputBuffer.charAt(this.currentIndex);
    }

    @Override
    public int getCurrentCodePoint() {
        return this.inputBuffer.codePointAt(this.currentIndex);
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean inPredicate() {
        if (this.matcher.getType() == MatcherType.PREDICATE) {
            return true;
        }
        return this.parent != null && this.parent.inPredicate();
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public String getMatch() {
        DefaultMatcherContext<V> ctx = this.subContext;
        return this.inputBuffer.extract(ctx.startIndex, ctx.currentIndex);
    }

    @Override
    public char getFirstMatchChar() {
        int index = this.subContext.startIndex;
        if (this.subContext.currentIndex > index) {
            return this.inputBuffer.charAt(index);
        }
        throw new InvalidGrammarException("getFirstMatchChar called but previous rule did not match anything");
    }

    @Override
    public int getMatchStartIndex() {
        return this.subContext.startIndex;
    }

    @Override
    public int getMatchEndIndex() {
        return this.subContext.currentIndex;
    }

    @Override
    public int getMatchLength() {
        return this.subContext.currentIndex - this.subContext.startIndex;
    }

    @Override
    public Position getPosition() {
        return this.inputBuffer.getPosition(this.currentIndex);
    }

    @Override
    public IndexRange getMatchRange() {
        return new IndexRange(this.subContext.startIndex, this.subContext.currentIndex);
    }

    @Override
    public ValueStack<V> getValueStack() {
        return this.valueStack;
    }

    @Override
    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    @Override
    public void setStartIndex(int startIndex) {
        Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0);
        this.startIndex = startIndex;
    }

    @Override
    public void setCurrentIndex(int currentIndex) {
        Preconditions.checkArgument((currentIndex >= 0 ? 1 : 0) != 0);
        this.currentIndex = currentIndex;
    }

    @Override
    public void advanceIndex(int delta) {
        this.currentIndex += delta;
    }

    @Override
    public MatcherContext<V> getBasicSubContext() {
        if (this.subContext == null) {
            this.subContext = new DefaultMatcherContext<V>(this.inputBuffer, this.valueStack, this.matchHandler, this, this.level + 1);
        } else {
            this.subContext.path = null;
        }
        return this.subContext;
    }

    @Override
    public MatcherContext<V> getSubContext(Matcher matcher) {
        DefaultMatcherContext sc = (DefaultMatcherContext)this.getBasicSubContext();
        sc.matcher = matcher;
        sc.setStartIndex(this.currentIndex);
        sc.setCurrentIndex(this.currentIndex);
        sc.hasError = false;
        return sc;
    }

    @Override
    public boolean runMatcher() {
        try {
            boolean ret = this.matchHandler.match(this);
            this.matcher = null;
            if (ret && this.parent != null) {
                this.parent.currentIndex = this.currentIndex;
            }
            return ret;
        }
        catch (GrappaException e) {
            throw e;
        }
        catch (Throwable e) {
            String msg = String.format("exception thrown when parsing %s '%s' at input position %s", this.matcher instanceof ActionMatcher ? "action" : "rule", this.getPath(), this.inputBuffer.getPosition(this.currentIndex));
            throw new GrappaException(msg, e);
        }
    }

    private String getPath() {
        if (this.path != null) {
            return this.path;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (MatcherContext<V> ctx = this; ctx != null; ctx = ctx.getParent()) {
            Matcher matcher = ctx.getMatcher();
            if (matcher == null) continue;
            list.add(matcher.toString());
        }
        Collections.reverse(list);
        this.path = JOINER.join(list);
        return this.path;
    }
}

