/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.run;

import com.github.fge.grappa.buffers.InputBuffer;
import com.github.fge.grappa.internal.NonFinalForTesting;
import com.github.fge.grappa.stack.ValueStack;
import java.util.Objects;
import javax.annotation.Nonnull;

@NonFinalForTesting
public class ParsingResult<V> {
    private final boolean matched;
    private final ValueStack<V> valueStack;
    private final InputBuffer inputBuffer;

    public ParsingResult(boolean matched, @Nonnull ValueStack<V> valueStack, @Nonnull InputBuffer inputBuffer) {
        this.matched = matched;
        this.valueStack = Objects.requireNonNull(valueStack);
        this.inputBuffer = Objects.requireNonNull(inputBuffer);
    }

    public boolean isSuccess() {
        return this.matched;
    }

    @Nonnull
    public V getTopStackValue() {
        return this.valueStack.peek();
    }

    @Nonnull
    public ValueStack<V> getValueStack() {
        return this.valueStack;
    }

    @Nonnull
    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }
}

