/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.run;

import com.github.fge.grappa.buffers.InputBuffer;
import com.github.fge.grappa.exceptions.GrappaException;
import com.github.fge.grappa.internal.NonFinalForTesting;
import com.github.fge.grappa.matchers.base.Matcher;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.run.AbstractParseRunner;
import com.github.fge.grappa.run.MatchHandler;
import com.github.fge.grappa.run.ParseRunnerListener;
import com.github.fge.grappa.run.ParsingResult;
import com.github.fge.grappa.run.context.MatcherContext;
import com.github.fge.grappa.run.events.MatchContextEvent;
import com.github.fge.grappa.run.events.MatchFailureEvent;
import com.github.fge.grappa.run.events.MatchSuccessEvent;
import com.github.fge.grappa.run.events.PostParseEvent;
import com.github.fge.grappa.run.events.PreMatchEvent;
import com.github.fge.grappa.run.events.PreParseEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@NonFinalForTesting
public class ListeningParseRunner<V>
extends AbstractParseRunner<V>
implements MatchHandler {
    private volatile Throwable throwable = null;
    private final EventBus bus = new EventBus(new SubscriberExceptionHandler(){

        public void handleException(Throwable exception, SubscriberExceptionContext context) {
            if (ListeningParseRunner.this.throwable == null) {
                ListeningParseRunner.this.throwable = exception;
            } else {
                ListeningParseRunner.this.throwable.addSuppressed(exception);
            }
        }
    });

    public ListeningParseRunner(Rule rule) {
        super(rule);
    }

    public final void registerListener(ParseRunnerListener<V> listener) {
        this.bus.register(listener);
    }

    @Override
    public ParsingResult<V> run(InputBuffer inputBuffer) {
        Objects.requireNonNull(inputBuffer, "inputBuffer");
        this.resetValueStack();
        MatcherContext rootContext = this.createRootContext(inputBuffer, this);
        this.bus.post(new PreParseEvent(rootContext));
        if (this.throwable != null) {
            throw new GrappaException("parsing listener error (before parse)", this.throwable);
        }
        boolean matched = rootContext.runMatcher();
        ParsingResult result = this.createParsingResult(matched, rootContext);
        this.bus.post(new PostParseEvent(result));
        if (this.throwable != null) {
            throw new GrappaException("parsing listener error (after parse)", this.throwable);
        }
        return result;
    }

    public <T> boolean match(MatcherContext<T> context) {
        Matcher matcher = context.getMatcher();
        PreMatchEvent<T> preMatchEvent = new PreMatchEvent<T>(context);
        this.bus.post(preMatchEvent);
        if (this.throwable != null) {
            throw new GrappaException("parsing listener error (before match)", this.throwable);
        }
        boolean match = matcher.match(context);
        MatchContextEvent postMatchEvent = match ? new MatchSuccessEvent<T>(context) : new MatchFailureEvent<T>(context);
        this.bus.post(postMatchEvent);
        if (this.throwable != null) {
            throw new GrappaException("parsing listener error (after match)", this.throwable);
        }
        return match;
    }
}

