/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.run;

import com.github.fge.grappa.buffers.CharSequenceInputBuffer;
import com.github.fge.grappa.buffers.InputBuffer;
import com.github.fge.grappa.internal.NonFinalForTesting;
import com.github.fge.grappa.matchers.base.Matcher;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.run.MatchHandler;
import com.github.fge.grappa.run.ParseRunner;
import com.github.fge.grappa.run.ParsingResult;
import com.github.fge.grappa.run.context.DefaultMatcherContext;
import com.github.fge.grappa.run.context.MatcherContext;
import com.github.fge.grappa.stack.DefaultValueStack;
import com.github.fge.grappa.stack.ValueStack;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractParseRunner<V>
implements ParseRunner<V> {
    protected final Matcher rootMatcher;
    protected ValueStack<V> valueStack;
    protected Object stackSnapshot;

    protected AbstractParseRunner(@Nonnull Rule rule) {
        this.rootMatcher = Objects.requireNonNull((Matcher)rule, "rule");
    }

    public final ValueStack<V> getValueStack() {
        return this.valueStack;
    }

    @Override
    public final ParsingResult<V> run(CharSequence input) {
        Objects.requireNonNull(input, "input");
        return this.run(new CharSequenceInputBuffer(input));
    }

    protected final void resetValueStack() {
        this.valueStack = new DefaultValueStack();
        this.stackSnapshot = null;
    }

    @NonFinalForTesting
    protected MatcherContext<V> createRootContext(InputBuffer inputBuffer, MatchHandler matchHandler) {
        return new DefaultMatcherContext<V>(inputBuffer, this.valueStack, matchHandler, this.rootMatcher);
    }

    @NonFinalForTesting
    protected ParsingResult<V> createParsingResult(boolean matched, MatcherContext<V> rootContext) {
        return new ParsingResult<V>(matched, this.valueStack, rootContext.getInputBuffer());
    }
}

