/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.parsers;

import com.github.fge.grappa.helpers.ValueBuilder;
import com.github.fge.grappa.parsers.BaseParser;
import com.github.fge.grappa.support.Var;
import com.google.common.eventbus.EventBus;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class ListeningParser<V>
extends BaseParser<V> {
    protected final EventBus bus = new EventBus();

    public final boolean register(@Nonnull Object listener) {
        this.bus.register(Objects.requireNonNull(listener));
        return true;
    }

    public final boolean unregister(@Nonnull Object listener) {
        this.bus.unregister(Objects.requireNonNull(listener));
        return true;
    }

    public final <T> boolean post(@Nonnull ValueBuilder<T> builder) {
        Objects.requireNonNull(builder);
        T event = builder.build();
        this.bus.post(event);
        builder.reset();
        return true;
    }

    public final <T> boolean post(@Nonnull Var<T> var) {
        Objects.requireNonNull(var);
        Object value = Objects.requireNonNull(var.get());
        this.bus.post(value);
        return true;
    }

    public final boolean postRaw(@Nonnull Object object) {
        Objects.requireNonNull(object);
        this.bus.post(object);
        return true;
    }
}

