/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.parsers;

import com.github.fge.grappa.annotations.Cached;
import com.github.fge.grappa.annotations.DontExtend;
import com.github.fge.grappa.annotations.DontLabel;
import com.github.fge.grappa.exceptions.InvalidGrammarException;
import com.github.fge.grappa.matchers.ActionMatcher;
import com.github.fge.grappa.matchers.AnyMatcher;
import com.github.fge.grappa.matchers.AnyOfMatcher;
import com.github.fge.grappa.matchers.CharIgnoreCaseMatcher;
import com.github.fge.grappa.matchers.CharMatcher;
import com.github.fge.grappa.matchers.CharRangeMatcher;
import com.github.fge.grappa.matchers.EmptyMatcher;
import com.github.fge.grappa.matchers.EndOfInputMatcher;
import com.github.fge.grappa.matchers.NothingMatcher;
import com.github.fge.grappa.matchers.StringIgnoreCaseMatcher;
import com.github.fge.grappa.matchers.StringMatcher;
import com.github.fge.grappa.matchers.delegate.FirstOfMatcher;
import com.github.fge.grappa.matchers.delegate.OneOrMoreMatcher;
import com.github.fge.grappa.matchers.delegate.OptionalMatcher;
import com.github.fge.grappa.matchers.delegate.SequenceMatcher;
import com.github.fge.grappa.matchers.delegate.ZeroOrMoreMatcher;
import com.github.fge.grappa.matchers.join.JoinMatcherBootstrap;
import com.github.fge.grappa.matchers.predicates.TestMatcher;
import com.github.fge.grappa.matchers.predicates.TestNotMatcher;
import com.github.fge.grappa.matchers.trie.Trie;
import com.github.fge.grappa.matchers.trie.TrieBuilder;
import com.github.fge.grappa.matchers.trie.TrieMatcher;
import com.github.fge.grappa.matchers.unicode.CodePointMatcher;
import com.github.fge.grappa.matchers.unicode.CodePointRangeMatcher;
import com.github.fge.grappa.parsers.BaseActions;
import com.github.fge.grappa.rules.Action;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.support.Characters;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class BaseParser<V>
extends BaseActions<V> {
    protected static final Rule EOI = new EndOfInputMatcher();
    protected static final Rule ANY = new AnyMatcher();
    protected static final Rule EMPTY = new EmptyMatcher();
    protected static final Rule NOTHING = new NothingMatcher();

    public Rule eof() {
        return EOI;
    }

    @Cached
    @DontLabel
    public Rule ch(char c) {
        return new CharMatcher(c);
    }

    @Cached
    @DontLabel
    public Rule ignoreCase(char c) {
        return Character.isLowerCase(c) == Character.isUpperCase(c) ? this.ch(c) : new CharIgnoreCaseMatcher(c);
    }

    @Cached
    @DontLabel
    public Rule unicodeChar(int codePoint) {
        if (!Character.isValidCodePoint(codePoint)) {
            throw new InvalidGrammarException("invalid code point " + codePoint);
        }
        return new CodePointMatcher(codePoint);
    }

    @Cached
    @DontLabel
    public Rule unicodeRange(int low, int high) {
        if (!Character.isValidCodePoint(low)) {
            throw new InvalidGrammarException("invalid code point " + low);
        }
        if (!Character.isValidCodePoint(high)) {
            throw new InvalidGrammarException("invalid code point " + high);
        }
        if (low > high) {
            throw new InvalidGrammarException("invalid code point range: " + low + " > " + high);
        }
        return low == high ? new CodePointMatcher(low) : new CodePointRangeMatcher(low, high);
    }

    @Cached
    @DontLabel
    public Rule charRange(char cLow, char cHigh) {
        return cLow == cHigh ? this.ch(cLow) : new CharRangeMatcher(cLow, cHigh);
    }

    @DontLabel
    public Rule anyOf(String characters) {
        Objects.requireNonNull(characters);
        return this.anyOf(characters.toCharArray());
    }

    @DontLabel
    public Rule anyOf(char[] characters) {
        Objects.requireNonNull(characters);
        Preconditions.checkArgument((characters.length > 0 ? 1 : 0) != 0);
        return characters.length == 1 ? this.ch(characters[0]) : this.anyOf(Characters.of(characters));
    }

    @Cached
    @DontLabel
    public Rule anyOf(Characters characters) {
        Objects.requireNonNull(characters);
        if (!characters.isSubtractive() && characters.getChars().length == 1) {
            return this.ch(characters.getChars()[0]);
        }
        if (characters.equals(Characters.NONE)) {
            return NOTHING;
        }
        return new AnyOfMatcher(characters);
    }

    @DontLabel
    public Rule noneOf(String characters) {
        Objects.requireNonNull(characters);
        return this.noneOf(characters.toCharArray());
    }

    @DontLabel
    public Rule noneOf(char[] characters) {
        Objects.requireNonNull(characters);
        Preconditions.checkArgument((characters.length > 0 ? 1 : 0) != 0);
        boolean containsEOI = false;
        for (char c : characters) {
            if (c != '\uffff') continue;
            containsEOI = true;
            break;
        }
        if (!containsEOI) {
            char[] withEOI = new char[characters.length + 1];
            System.arraycopy(characters, 0, withEOI, 0, characters.length);
            withEOI[characters.length] = 65535;
            characters = withEOI;
        }
        return this.anyOf(Characters.allBut(characters));
    }

    @DontLabel
    public Rule string(String string) {
        Objects.requireNonNull(string);
        return this.string(string.toCharArray());
    }

    @Cached
    @DontLabel
    public Rule string(char ... characters) {
        if (characters.length == 1) {
            return this.ch(characters[0]);
        }
        return new StringMatcher(new String(characters));
    }

    @DontLabel
    public Rule ignoreCase(String string) {
        Objects.requireNonNull(string);
        return this.ignoreCase(string.toCharArray());
    }

    @Cached
    @DontLabel
    public Rule ignoreCase(char ... characters) {
        if (characters.length == 1) {
            return this.ignoreCase(characters[0]);
        }
        return new StringIgnoreCaseMatcher(new String(characters));
    }

    @Cached
    public Rule trie(Collection<String> strings) {
        ImmutableList list = ImmutableList.copyOf(strings);
        TrieBuilder builder = Trie.newBuilder();
        for (String word : list) {
            builder.addWord(word);
        }
        return new TrieMatcher(builder.build());
    }

    public Rule trie(String first, String second, String ... others) {
        ImmutableList words = ImmutableList.builder().add((Object)first).add((Object)second).add((Object[])others).build();
        return this.trie((Collection<String>)words);
    }

    @DontLabel
    public Rule firstOf(Object rule, Object rule2, Object ... moreRules) {
        Objects.requireNonNull(moreRules);
        Object[] rules = ImmutableList.builder().add(rule).add(rule2).add(moreRules).build().toArray();
        return this.firstOf(rules);
    }

    @Cached
    @DontLabel
    public Rule firstOf(Object[] rules) {
        Objects.requireNonNull(rules, "rules");
        if (rules.length == 1) {
            return this.toRule(rules[0]);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (Object object : rules) {
            if (!(object instanceof String)) {
                return new FirstOfMatcher(this.toRules(rules));
            }
            strings.add((String)object);
        }
        return this.trie(strings);
    }

    @Cached
    @DontLabel
    public Rule oneOrMore(Object rule) {
        return new OneOrMoreMatcher(this.toRule(rule));
    }

    @DontLabel
    public Rule oneOrMore(Object rule, Object rule2, Object ... moreRules) {
        Objects.requireNonNull(moreRules);
        return this.oneOrMore(this.sequence(rule, rule2, moreRules));
    }

    @Cached
    @DontLabel
    public Rule optional(Object rule) {
        Objects.requireNonNull(rule);
        return new OptionalMatcher(this.toRule(rule));
    }

    @DontLabel
    public Rule optional(Object rule, Object rule2, Object ... moreRules) {
        Objects.requireNonNull(moreRules);
        return this.optional(this.sequence(rule, rule2, moreRules));
    }

    @DontLabel
    public Rule sequence(Object rule, Object rule2, Object ... moreRules) {
        Object[] rules = ImmutableList.builder().add(rule).add(rule2).add(moreRules).build().toArray();
        return this.sequence(rules);
    }

    @Cached
    @DontLabel
    public Rule sequence(Object[] rules) {
        Objects.requireNonNull(rules);
        return rules.length == 1 ? this.toRule(rules[0]) : new SequenceMatcher(this.toRules(rules));
    }

    public final JoinMatcherBootstrap<V, BaseParser<V>> join(Object rule) {
        return new JoinMatcherBootstrap(this, rule);
    }

    @Cached
    @DontLabel
    public Rule test(Object rule) {
        Rule subMatcher = this.toRule(rule);
        return new TestMatcher(subMatcher);
    }

    @DontLabel
    public Rule test(Object rule, Object rule2, Object ... moreRules) {
        Objects.requireNonNull(moreRules);
        return this.test(this.sequence(rule, rule2, moreRules));
    }

    @Cached
    @DontLabel
    public Rule testNot(Object rule) {
        return new TestNotMatcher(this.toRule(rule));
    }

    @DontLabel
    public Rule testNot(Object rule, Object rule2, Object ... moreRules) {
        Objects.requireNonNull(moreRules);
        return this.testNot(this.sequence(rule, rule2, moreRules));
    }

    @Cached
    @DontLabel
    public Rule zeroOrMore(Object rule) {
        return new ZeroOrMoreMatcher(this.toRule(rule));
    }

    @DontLabel
    public Rule zeroOrMore(Object rule, Object rule2, Object ... moreRules) {
        Objects.requireNonNull(moreRules);
        return this.zeroOrMore(this.sequence(rule, rule2, moreRules));
    }

    @Cached
    @DontLabel
    public Rule nTimes(int repetitions, Object rule) {
        Objects.requireNonNull(rule);
        if (repetitions < 0) {
            throw new InvalidGrammarException("illegal repetition count " + repetitions + ": must not be negative");
        }
        Rule theRule = this.toRule(rule);
        if (repetitions == 0) {
            return EMPTY;
        }
        if (repetitions == 1) {
            return theRule;
        }
        Object[] array = new Rule[repetitions];
        Arrays.fill(array, theRule);
        return this.sequence(array);
    }

    public Rule alpha() {
        return this.firstOf(this.charRange('a', 'z'), this.charRange('A', 'Z'), new Object[0]);
    }

    public Rule bit() {
        return this.anyOf(Characters.of('0', '1'));
    }

    public Rule asciiChars() {
        return this.charRange('\u0001', '\u007f');
    }

    public Rule cr() {
        return this.ch('\r');
    }

    public Rule crlf() {
        return this.string("\r\n");
    }

    public Rule ctl() {
        return this.firstOf(this.charRange('\u0000', '\u001f'), this.ch('\u007f'), new Object[0]);
    }

    public Rule digit() {
        return this.charRange('0', '9');
    }

    public Rule dquote() {
        return this.ch('\"');
    }

    public Rule hexDigit() {
        return this.anyOf("ABCDEFabcdef0123456789");
    }

    public Rule hexDigitUpperCase() {
        return this.anyOf("ABCDEF0123456789");
    }

    public Rule hexDigitLowerCase() {
        return this.anyOf("abcdef0123456789");
    }

    public Rule hTab() {
        return this.ch('\t');
    }

    public Rule lf() {
        return this.ch('\n');
    }

    public Rule octet() {
        return this.charRange('\u0000', '\u00ff');
    }

    public Rule sp() {
        return this.ch(' ');
    }

    public Rule vchar() {
        return this.charRange('!', '~');
    }

    public Rule wsp() {
        return this.anyOf(" \t");
    }

    public static <T> Action<T> ACTION(boolean expression) {
        throw new UnsupportedOperationException("ACTION(...) calls can only be used in Rule creating parser methods");
    }

    @DontExtend
    protected Rule fromCharLiteral(char c) {
        return this.ch(c);
    }

    @DontExtend
    protected Rule fromStringLiteral(String string) {
        Objects.requireNonNull(string);
        return this.fromCharArray(string.toCharArray());
    }

    @DontExtend
    protected Rule fromCharArray(char[] array) {
        Objects.requireNonNull(array);
        return this.string(array);
    }

    @DontExtend
    public Rule[] toRules(Object ... objects) {
        Rule[] rules = new Rule[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            rules[i] = this.toRule(objects[i]);
        }
        return rules;
    }

    @DontExtend
    public Rule toRule(Object obj) {
        Objects.requireNonNull(obj);
        if (obj instanceof Rule) {
            return (Rule)obj;
        }
        if (obj instanceof Character) {
            return this.fromCharLiteral(((Character)obj).charValue());
        }
        if (obj instanceof String) {
            return this.fromStringLiteral((String)obj);
        }
        if (obj instanceof char[]) {
            return this.fromCharArray((char[])obj);
        }
        if (obj instanceof Action) {
            Action action = (Action)obj;
            return new ActionMatcher(action);
        }
        String errmsg = obj instanceof Boolean ? "unwrapped Boolean value in rule (wrap it with ACTION())" : "'" + obj + "' cannot be automatically converted to a rule";
        throw new InvalidGrammarException(errmsg);
    }
}

