/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.misc;

import com.github.fge.grappa.parsers.BaseParser;
import com.github.fge.grappa.run.context.ContextAware;
import com.github.fge.grappa.support.Var;
import com.github.fge.grappa.transform.ClassCache;
import com.github.fge.grappa.transform.LoadingOpcode;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Nullable;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class AsmUtils {
    private static final ClassCache CACHE = ClassCache.INSTANCE;

    private AsmUtils() {
    }

    public static String getExtendedParserClassName(String parserClassName) {
        Objects.requireNonNull(parserClassName, "parserClassName");
        return parserClassName + "$$grappa";
    }

    public static Class<?> getClassForType(Type type) {
        Objects.requireNonNull(type, "type");
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 0: {
                return Void.TYPE;
            }
            case 9: 
            case 10: {
                return CACHE.loadClass(type.getInternalName());
            }
        }
        throw new IllegalStateException();
    }

    public static Field getClassField(String classInternalName, String fieldName) {
        Class<?> c;
        Objects.requireNonNull(classInternalName, "classInternalName");
        Objects.requireNonNull(fieldName, "fieldName");
        for (Class<?> current = c = CACHE.loadClass(classInternalName); current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        throw new RuntimeException("Field '" + fieldName + "' not found in '" + c.getCanonicalName() + "' or any superclass");
    }

    public static Method getClassMethod(String classInternalName, String methodName, String methodDesc) {
        Objects.requireNonNull(classInternalName, "classInternalName");
        Objects.requireNonNull(methodName, "methodName");
        Objects.requireNonNull(methodDesc, "methodDesc");
        Class<?> c = CACHE.loadClass(classInternalName);
        Type[] types = Type.getArgumentTypes((String)methodDesc);
        Class[] argTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            argTypes[i] = AsmUtils.getClassForType(types[i]);
        }
        Method method = AsmUtils.findMethod(c, methodName, argTypes);
        if (method == null) {
            throw new RuntimeException("Method '" + methodName + "' with descriptor '" + methodDesc + "' not found in '" + c + "' or any supertype");
        }
        return method;
    }

    @Nullable
    private static Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ignored) {
            Method ret = AsmUtils.findMethod(clazz.getSuperclass(), methodName, argTypes);
            if (ret != null) {
                return ret;
            }
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                ret = AsmUtils.findMethod(interfaceClass, methodName, argTypes);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }
    }

    public static Constructor<?> getClassConstructor(String classInternalName, String constructorDesc) {
        Objects.requireNonNull(classInternalName, "classInternalName");
        Objects.requireNonNull(constructorDesc, "constructorDesc");
        Class<?> c = CACHE.loadClass(classInternalName);
        Type[] types = Type.getArgumentTypes((String)constructorDesc);
        Class[] argTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            argTypes[i] = AsmUtils.getClassForType(types[i]);
        }
        try {
            return c.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Constructor with descriptor '" + constructorDesc + "' not found in '" + c, e);
        }
    }

    @Nullable
    public static Class<?> findLoadedClass(String className, ClassLoader classLoader) {
        Method m;
        Class<?> c;
        Objects.requireNonNull(className, "className");
        Objects.requireNonNull(classLoader, "classLoader");
        try {
            c = Class.forName("java.lang.ClassLoader");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not determine whether class '" + className + "' has already been loaded", e);
        }
        try {
            m = c.getDeclaredMethod("findLoadedClass", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not determine whether class '" + className + "' has already been loaded", e);
        }
        m.setAccessible(true);
        try {
            Class e = (Class)m.invoke((Object)classLoader, className);
            return e;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Could not determine whether class '" + className + "' has already been loaded", e);
        }
        finally {
            m.setAccessible(false);
        }
    }

    public static Class<?> loadClass(String className, byte[] code, ClassLoader classLoader) {
        Method m;
        Class<?> c;
        Objects.requireNonNull(className, "className");
        Objects.requireNonNull(code, "code");
        Objects.requireNonNull(classLoader, "classLoader");
        try {
            c = Class.forName("java.lang.ClassLoader");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class '" + className + '\'', e);
        }
        try {
            m = c.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not load class '" + className + '\'', e);
        }
        m.setAccessible(true);
        try {
            Class e = (Class)m.invoke((Object)classLoader, className, code, 0, code.length);
            return e;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Could not load class '" + className + '\'', e);
        }
        finally {
            m.setAccessible(false);
        }
    }

    public static InsnList createArgumentLoaders(String methodDescriptor) {
        Objects.requireNonNull(methodDescriptor, "methodDescriptor");
        InsnList instructions = new InsnList();
        Type[] types = Type.getArgumentTypes((String)methodDescriptor);
        for (int i = 0; i < types.length; ++i) {
            int opcode = LoadingOpcode.forType(types[i]);
            VarInsnNode node = new VarInsnNode(opcode, i + 1);
            instructions.add((AbstractInsnNode)node);
        }
        return instructions;
    }

    public static boolean isAssignableTo(String classInternalName, Class<?> type) {
        Objects.requireNonNull(classInternalName, "classInternalName");
        Objects.requireNonNull(type, "type");
        Class<?> c = CACHE.loadClass(classInternalName);
        return type.isAssignableFrom(c);
    }

    public static boolean isBooleanValueOfZ(AbstractInsnNode insn) {
        Objects.requireNonNull(insn, "insn");
        if (insn.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isBooleanValueOfZ(mi.owner, mi.name, mi.desc);
    }

    public static boolean isBooleanValueOfZ(String methodOwner, String methodName, String methodDesc) {
        Objects.requireNonNull(methodOwner, "methodOwner");
        Objects.requireNonNull(methodName, "methodName");
        Objects.requireNonNull(methodDesc, "methodDesc");
        return CodegenUtils.p(Boolean.class).equals(methodOwner) && "valueOf".equals(methodName) && CodegenUtils.sig(Boolean.class, (Class[])new Class[]{Boolean.TYPE}).equals(methodDesc);
    }

    public static boolean isActionRoot(AbstractInsnNode insn) {
        Objects.requireNonNull(insn, "insn");
        if (insn.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isActionRoot(mi.owner, mi.name);
    }

    public static boolean isActionRoot(String methodOwner, String methodName) {
        Objects.requireNonNull(methodOwner, "methodOwner");
        Objects.requireNonNull(methodName, "methodName");
        return "ACTION".equals(methodName) && AsmUtils.isAssignableTo(methodOwner, BaseParser.class);
    }

    public static boolean isVarRoot(AbstractInsnNode insn) {
        Objects.requireNonNull(insn, "insn");
        if (insn.getOpcode() != 183) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isVarRoot(mi.owner, mi.name, mi.desc);
    }

    public static boolean isVarRoot(String methodOwner, String methodName, String methodDesc) {
        Objects.requireNonNull(methodOwner, "methodOwner");
        Objects.requireNonNull(methodName, "methodName");
        Objects.requireNonNull(methodDesc, "methodDesc");
        return "<init>".equals(methodName) && CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{Object.class}).equals(methodDesc) && AsmUtils.isAssignableTo(methodOwner, Var.class);
    }

    public static boolean isCallOnContextAware(AbstractInsnNode insn) {
        Objects.requireNonNull(insn, "insn");
        if (insn.getOpcode() != 182 && insn.getOpcode() != 185) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isAssignableTo(mi.owner, ContextAware.class);
    }
}

