/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers.wrap;

import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.Matcher;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.run.context.MatcherContext;
import com.github.fge.grappa.support.Var;
import java.util.List;
import java.util.Objects;

public final class VarFramingMatcher
implements Matcher {
    private final Matcher inner;
    private final Var<?>[] variables;

    public VarFramingMatcher(Rule inner, Var<?>[] variables) {
        this.inner = Objects.requireNonNull((Matcher)inner, "inner");
        this.variables = Objects.requireNonNull(variables, "variables");
    }

    @Override
    public MatcherType getType() {
        return this.inner.getType();
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        for (Var<?> var : this.variables) {
            var.enterFrame();
        }
        boolean matched = this.inner.match(context);
        for (Var<?> var : this.variables) {
            var.exitFrame();
        }
        return matched;
    }

    @Override
    public List<Matcher> getChildren() {
        return this.inner.getChildren();
    }

    @Override
    public Rule label(String label) {
        return new VarFramingMatcher(this.inner.label(label), this.variables);
    }

    @Override
    public String getLabel() {
        return this.inner.getLabel();
    }

    @Override
    public boolean hasCustomLabel() {
        return this.inner.hasCustomLabel();
    }

    @Override
    public <V> MatcherContext<V> getSubContext(MatcherContext<V> context) {
        MatcherContext<V> subContext = this.inner.getSubContext(context);
        subContext.setMatcher(this);
        return subContext;
    }

    public String toString() {
        return this.inner.toString();
    }

    public static Matcher unwrap(Matcher matcher) {
        if (!(matcher instanceof VarFramingMatcher)) {
            return matcher;
        }
        return VarFramingMatcher.unwrap(((VarFramingMatcher)matcher).inner);
    }
}

