/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers.wrap;

import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.Matcher;
import com.github.fge.grappa.rules.Rule;
import com.github.fge.grappa.run.context.MatcherContext;
import java.util.List;
import java.util.Objects;

public final class ProxyMatcher
implements Matcher,
Cloneable {
    private Matcher target;
    private String label;
    private boolean dirty;

    @Override
    public MatcherType getType() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getType();
    }

    @Override
    public List<Matcher> getChildren() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getChildren();
    }

    public void setLabel(String label) {
        this.label = label;
        this.updateDirtyFlag();
    }

    private void updateDirtyFlag() {
        this.dirty = this.label != null;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (this.dirty) {
            this.apply();
        }
        return this.target.match(context);
    }

    @Override
    public String getLabel() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getLabel();
    }

    @Override
    public boolean hasCustomLabel() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.hasCustomLabel();
    }

    public String toString() {
        if (this.target == null) {
            return super.toString();
        }
        if (this.dirty) {
            this.apply();
        }
        return this.target.toString();
    }

    private void apply() {
        if (this.label != null) {
            this.label(this.label);
        }
    }

    @Override
    public Rule label(String label) {
        if (this.target == null) {
            if (this.label == null) {
                this.setLabel(label);
                return this;
            }
            ProxyMatcher anotherProxy = this.createClone();
            anotherProxy.setLabel(label);
            anotherProxy.arm(this);
            return anotherProxy;
        }
        Matcher inner = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)inner.label(label);
        this.setLabel(null);
        return this.target;
    }

    public void arm(Matcher target) {
        this.target = Objects.requireNonNull(target, "target");
    }

    public static Matcher unwrap(Matcher matcher) {
        if (matcher instanceof ProxyMatcher) {
            ProxyMatcher proxyMatcher = (ProxyMatcher)matcher;
            if (proxyMatcher.dirty) {
                proxyMatcher.apply();
            }
            return proxyMatcher.target == null ? proxyMatcher : proxyMatcher.target;
        }
        return matcher;
    }

    @Override
    public <V> MatcherContext<V> getSubContext(MatcherContext<V> context) {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getSubContext(context);
    }

    private ProxyMatcher createClone() {
        try {
            return (ProxyMatcher)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

