/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers.trie;

import com.github.fge.grappa.matchers.trie.Trie;
import com.github.fge.grappa.matchers.trie.TrieNodeBuilder;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

@Beta
public final class TrieBuilder {
    int nrWords;
    int maxLength = 0;
    final TrieNodeBuilder nodeBuilder = new TrieNodeBuilder();

    TrieBuilder() {
    }

    public TrieBuilder addWord(@Nonnull String word) {
        Objects.requireNonNull(word);
        Preconditions.checkArgument((word.length() >= 2 ? 1 : 0) != 0, (Object)"strings in a trie must be two characters long or greater");
        ++this.nrWords;
        this.maxLength = Math.max(this.maxLength, word.length());
        this.nodeBuilder.addWord(word);
        return this;
    }

    public Trie build() {
        return new Trie(this);
    }
}

