/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.matchers;

import com.github.fge.grappa.matchers.MatcherType;
import com.github.fge.grappa.matchers.base.AbstractMatcher;
import com.github.fge.grappa.run.context.MatcherContext;
import java.util.Objects;

public final class StringIgnoreCaseMatcher
extends AbstractMatcher {
    private final String input;

    public StringIgnoreCaseMatcher(String input) {
        super("stringIgnoreCase(" + input + ')');
        this.input = Objects.requireNonNull(input);
    }

    @Override
    public MatcherType getType() {
        return MatcherType.TERMINAL;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        int len = this.input.length();
        int index = context.getCurrentIndex();
        String s = context.getInputBuffer().extract(index, index + len);
        if (!s.equalsIgnoreCase(this.input)) {
            return false;
        }
        context.advanceIndex(len);
        return true;
    }
}

