/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa;

import com.github.fge.grappa.exceptions.InvalidGrammarException;
import com.github.fge.grappa.parsers.BaseParser;
import com.github.fge.grappa.transform.ParserTransformer;
import java.lang.reflect.Constructor;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class Grappa {
    private Grappa() {
        throw new Error("nice try!");
    }

    public static <P extends BaseParser<V>, V> P createParser(@Nonnull Class<P> parserClass, Object ... constructorArgs) {
        Objects.requireNonNull(parserClass, "parserClass");
        try {
            Class<P> extendedClass = ParserTransformer.transformParser(parserClass);
            Constructor<?> constructor = Grappa.findConstructor(extendedClass, constructorArgs);
            BaseParser ret = (BaseParser)constructor.newInstance(constructorArgs);
            return (P)ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating extended parser class: " + e.getMessage(), e);
        }
    }

    public static <P extends BaseParser<V>, V> byte[] getByteCode(Class<P> parserClass) {
        try {
            return ParserTransformer.getByteCode(parserClass);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to generate byte code", e);
        }
    }

    private static Constructor<?> findConstructor(Class<?> c, Object[] arguments) {
        block0: for (Constructor<?> constructor : c.getConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length != arguments.length) continue;
            for (int i = 0; i < arguments.length; ++i) {
                Object argument = arguments[i];
                if (argument != null && !paramTypes[i].isAssignableFrom(argument.getClass()) || argument == null && paramTypes[i].isPrimitive()) continue block0;
            }
            return constructor;
        }
        throw new InvalidGrammarException("No constructor found for " + c + " and the given " + arguments.length + " arguments");
    }
}

