/*
 * Copyright (C) 2009-2011 Mathias Doenitz
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.github.fge.grappa.support;

import com.google.common.base.MoreObjects;

/**
 * Simple container class for a line/column position in the input text.
 */
public final class Position
{
    private final int line;
    private final int column;

    public Position(final int line, final int column)
    {
        this.line = line;
        this.column = column;
    }

    public int getLine()
    {
        return line;
    }

    public int getColumn()
    {
        return column;
    }

    @Override
    public boolean equals(final Object obj)
    {
        if (this == obj)
            return true;
        if (!(obj instanceof Position))
            return false;
        final Position position = (Position) obj;
        return column == position.column && line == position.line;

    }

    @Override
    public int hashCode()
    {
        return line ^ column;
    }

    @Override
    public String toString()
    {
        return MoreObjects.toStringHelper(this)
            .add("line", line)
            .add("column", column)
            .toString();
    }
}
