/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model.functions;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;

public abstract class AbstractOneToOneMatcher<U, V> {
    private final EnforcerRuleHelper helper;

    AbstractOneToOneMatcher(EnforcerRuleHelper helper) {
        this.helper = helper;
    }

    public final BiMap<V, V> match(Collection<U> superset, Collection<V> subset) {
        ImmutableBiMap.Builder mapBuilder = ImmutableBiMap.builder();
        Collection<V> transformedSuperset = this.transformSuperset(superset);
        for (V subsetItem : subset) {
            boolean itemMatched = false;
            for (V supersetItem : transformedSuperset) {
                if (!this.matches(supersetItem, subsetItem)) continue;
                itemMatched = true;
                mapBuilder.put(supersetItem, subsetItem);
                break;
            }
            if (itemMatched) continue;
            this.handleUnmatchedItem(mapBuilder, subsetItem);
        }
        return mapBuilder.build();
    }

    protected void handleUnmatchedItem(ImmutableBiMap.Builder<V, V> mapBuilder, V subsetItem) {
        throw new IllegalArgumentException("Could not match item " + subsetItem + " with superset");
    }

    protected abstract V transform(U var1);

    protected abstract boolean matches(V var1, V var2);

    EnforcerRuleHelper getHelper() {
        return this.helper;
    }

    private Collection<V> transformSuperset(Collection<U> superset) {
        ArrayList<V> transformed = new ArrayList<V>(superset.size());
        for (U supersetItem : superset) {
            transformed.add(this.transform(supersetItem));
        }
        return transformed;
    }
}

