/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.PluginModel;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PedanticPluginConfigurationEnforcer
extends AbstractPedanticEnforcer {
    private boolean manageVersions = true;
    private boolean allowUnmanagedProjectVersions = true;
    private final Set<String> allowedUnmanagedProjectVersionProperties = new HashSet<String>(DEFAULT_ALLOWED_VERSION_PROPERTIES);
    private static final Set<String> DEFAULT_ALLOWED_VERSION_PROPERTIES = ImmutableSet.of((Object)"${version}", (Object)"${project.version}");
    private boolean manageConfigurations = true;
    private boolean manageDependencies = true;

    public void setManageVersions(boolean manageVersions) {
        this.manageVersions = manageVersions;
    }

    public void setAllowUnmanagedProjectVersions(boolean allowUnmanagedProjectVersions) {
        this.allowUnmanagedProjectVersions = allowUnmanagedProjectVersions;
    }

    public void setAllowedUnmanagedProjectVersionProperties(String allowedUnmanagedProjectVersionProperties) {
        CommaSeparatorUtils.splitAndAddToCollection(allowedUnmanagedProjectVersionProperties, this.allowedUnmanagedProjectVersionProperties, property -> String.format("${%s}", property));
    }

    public void setManageConfigurations(boolean manageConfigurations) {
        this.manageConfigurations = manageConfigurations;
    }

    public void setManageDependencies(boolean manageDependencies) {
        this.manageDependencies = manageDependencies;
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.PLUGIN_CONFIGURATION;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        if (this.manageVersions) {
            this.enforceManagedVersions(report);
        }
        if (this.manageConfigurations) {
            this.enforceManagedConfiguration(report);
        }
        if (this.manageDependencies) {
            this.enforceManagedDependencies(report);
        }
    }

    private void enforceManagedVersions(ErrorReport report) {
        Collection versionedPlugins = this.searchForPlugins(plugin -> plugin.getVersion() != null);
        if (this.allowUnmanagedProjectVersions) {
            versionedPlugins = versionedPlugins.stream().filter(plugin -> !this.allowedUnmanagedProjectVersionProperties.contains(plugin.getVersion())).collect(Collectors.toList());
        }
        if (!versionedPlugins.isEmpty()) {
            report.addLine("Plugin versions have to be declared in <pluginManagement>:").addLine(ErrorReport.toList(versionedPlugins));
        }
    }

    private void enforceManagedConfiguration(ErrorReport report) {
        Collection<PluginModel> configuredPlugins = this.searchForPlugins(PluginModel::isConfigured);
        if (!configuredPlugins.isEmpty()) {
            report.addLine("Use <pluginManagement> to configure these plugins or configure them for a specific <execution>:").addLine(ErrorReport.toList(configuredPlugins));
        }
    }

    private void enforceManagedDependencies(ErrorReport report) {
        Collection<PluginModel> pluginsWithDependencies = this.searchForPlugins(plugin -> !plugin.getDependencies().isEmpty());
        if (!pluginsWithDependencies.isEmpty()) {
            report.addLine("Use <pluginManagement> to configure plugin dependencies:").addLine(ErrorReport.toList(pluginsWithDependencies));
        }
    }

    private Collection<PluginModel> searchForPlugins(Predicate<PluginModel> predicate) {
        List<PluginModel> plugins = this.getProjectModel().getPlugins();
        return plugins.stream().filter(predicate).collect(Collectors.toList());
    }
}

