/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.DependencyModel;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PedanticDependencyConfigurationEnforcer
extends AbstractPedanticEnforcer {
    private boolean manageVersions = true;
    private boolean allowUnmanagedProjectVersions = true;
    private final Set<String> allowedUnmanagedProjectVersionProperties = new HashSet<String>(DEFAULT_ALLOWED_VERSION_PROPERTIES);
    private static final Set<String> DEFAULT_ALLOWED_VERSION_PROPERTIES = ImmutableSet.of((Object)"${version}", (Object)"${project.version}");
    private boolean manageExclusions = true;

    public void setManageVersions(boolean manageVersions) {
        this.manageVersions = manageVersions;
    }

    public void setAllowUnmanagedProjectVersions(boolean allowUnmanagedProjectVersions) {
        this.allowUnmanagedProjectVersions = allowUnmanagedProjectVersions;
    }

    public void setAllowedUnmanagedProjectVersionProperties(String allowedUnmanagedProjectVersionProperties) {
        CommaSeparatorUtils.splitAndAddToCollection(allowedUnmanagedProjectVersionProperties, this.allowedUnmanagedProjectVersionProperties, property -> String.format("${%s}", property));
    }

    public void setManageExclusions(boolean manageExclusions) {
        this.manageExclusions = manageExclusions;
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.DEPENDENCY_CONFIGURATION;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        if (this.manageVersions) {
            this.enforceManagedVersions(report);
        }
        if (this.manageExclusions) {
            this.enforceManagedExclusion(report);
        }
    }

    private void enforceManagedVersions(ErrorReport report) {
        Collection versionedDependencies = this.searchForDependencies(dep -> dep.getVersion() != null);
        if (this.allowUnmanagedProjectVersions) {
            versionedDependencies = versionedDependencies.stream().filter(dep -> !this.allowedUnmanagedProjectVersionProperties.contains(dep.getVersion())).collect(Collectors.toList());
        }
        if (!versionedDependencies.isEmpty()) {
            report.addLine("Dependency versions have to be declared in <dependencyManagement>:").addLine(ErrorReport.toList(versionedDependencies));
        }
    }

    private void enforceManagedExclusion(ErrorReport report) {
        Collection<DependencyModel> depsWithExclusions = this.searchForDependencies(dep -> !dep.getExclusions().isEmpty());
        if (!depsWithExclusions.isEmpty()) {
            report.addLine("Dependency exclusions have to be declared in <dependencyManagement>:").addLine(ErrorReport.toList(depsWithExclusions));
        }
    }

    private Collection<DependencyModel> searchForDependencies(Predicate<DependencyModel> predicate) {
        List<DependencyModel> dependencies = this.getProjectModel().getDependencies();
        return dependencies.stream().filter(predicate).collect(Collectors.toList());
    }
}

