/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.util;

import java.util.Map;
import org.adoptopenjdk.jitwatch.model.IParseDictionary;
import org.adoptopenjdk.jitwatch.util.ParseUtil;
import org.adoptopenjdk.jitwatch.util.StringUtil;

public final class TooltipUtil {
    private TooltipUtil() {
    }

    public static String buildInlineAnnotationText(boolean inlined, String reason, Map<String, String> callAttrs, Map<String, String> methodAttrs, IParseDictionary parseDictionary) {
        StringBuilder builder = new StringBuilder();
        String holder = methodAttrs.get("holder");
        String methodName = methodAttrs.get("name");
        builder.append("Class: ").append(ParseUtil.lookupType(holder, parseDictionary)).append("\n");
        builder.append("Method: ").append(StringUtil.replaceXMLEntities(methodName)).append("\n");
        builder.append("JIT Compiled: ");
        if (methodAttrs.containsKey("compile_id")) {
            builder.append("Yes\n");
        } else {
            builder.append("No\n");
        }
        builder.append("Inlined: ");
        if (inlined) {
            builder.append("Yes, ");
        } else {
            builder.append("No, ");
        }
        builder.append(reason);
        if (callAttrs.containsKey("count")) {
            builder.append("\nCount: ").append(callAttrs.get("count"));
        }
        if (methodAttrs.containsKey("iicount")) {
            builder.append("\niicount: ").append(methodAttrs.get("iicount"));
        }
        if (methodAttrs.containsKey("bytes")) {
            builder.append("\nBytes: ").append(methodAttrs.get("bytes"));
        }
        if (callAttrs.containsKey("prof_factor")) {
            builder.append("\nProf factor: ").append(callAttrs.get("prof_factor"));
        }
        return builder.toString();
    }
}

