/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import java.util.Map;
import org.adoptopenjdk.jitwatch.model.IParseDictionary;
import org.adoptopenjdk.jitwatch.model.ParseDictionary;
import org.adoptopenjdk.jitwatch.model.Tag;
import org.adoptopenjdk.jitwatch.util.ParseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task
extends Tag {
    private static final Logger logger = LoggerFactory.getLogger(Task.class);
    private IParseDictionary parseDictionary = new ParseDictionary();

    public Task(String name, Map<String, String> attrs, boolean selfClosing) {
        super(name, attrs, selfClosing);
    }

    public IParseDictionary getParseDictionary() {
        return this.parseDictionary;
    }

    public void addDictionaryType(String type, Tag tag) {
        this.parseDictionary.setType(type, tag);
    }

    public void addDictionaryMethod(String method, Tag tag) {
        this.parseDictionary.setMethod(method, tag);
    }

    public void addDictionaryKlass(String klass, Tag tag) {
        this.parseDictionary.setKlass(klass, tag);
    }

    public String decodeParseMethod(String method) {
        StringBuilder builder = new StringBuilder();
        Tag methodTag = this.parseDictionary.getMethod(method);
        String returnTypeID = methodTag.getAttribute("return");
        String args = methodTag.getAttribute("arguments");
        String methodName = methodTag.getAttribute("name");
        String klassId = methodTag.getAttribute("holder");
        Tag klassTag = this.parseDictionary.getKlass(klassId);
        String klassName = klassTag.getAttribute("name");
        klassName = klassName.replace("/", ".");
        builder.append(" <!-- ");
        builder.append(this.getTypeOrKlass(returnTypeID));
        builder.append(' ');
        builder.append(klassName);
        builder.append(".");
        builder.append(methodName);
        builder.append("(");
        if (args != null && args.length() > 0) {
            String[] ids;
            for (String id : ids = args.split(" ")) {
                builder.append(this.getTypeOrKlass(id));
                builder.append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(") -->");
        return builder.toString();
    }

    private String getTypeOrKlass(String id) {
        Tag typeTag = this.parseDictionary.getType(id);
        String result = null;
        if (typeTag == null) {
            Tag klassTag = this.parseDictionary.getKlass(id);
            if (klassTag != null) {
                result = klassTag.getAttribute("name");
                result = result.replace("/", ".");
            }
        } else {
            result = typeTag.getAttribute("name");
        }
        result = result == null ? "???" : ParseUtil.expandParameterType(result);
        return result;
    }
}

