/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tag {
    private String name;
    private Map<String, String> attrs = new HashMap<String, String>();
    private List<Tag> children = new ArrayList<Tag>();
    private Tag parent = null;
    private boolean selfClosing = false;
    private boolean isFragment = false;
    private String textContent = null;
    private String closingTag;
    private static final String INDENT = "  ";

    public Tag(String name, Map<String, String> attrs, boolean selfClosing) {
        this.name = name;
        this.attrs = attrs;
        this.selfClosing = selfClosing;
        StringBuilder builder = new StringBuilder();
        builder.append('<').append('/').append(name).append('>');
        this.closingTag = builder.toString();
    }

    public void addTextContent(String text) {
        this.textContent = this.textContent == null ? text : this.textContent + text;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void addChild(Tag child) {
        child.setParent(this);
        this.children.add(child);
    }

    public List<Tag> getChildren() {
        return this.children;
    }

    public boolean isSelfClosing() {
        return this.selfClosing;
    }

    public String getClosingTag() {
        return this.closingTag;
    }

    public Tag getFirstNamedChild(String name) {
        List<Tag> namedChildren = this.getNamedChildren(name);
        if (namedChildren.size() > 0) {
            return namedChildren.get(0);
        }
        return null;
    }

    public List<Tag> getNamedChildren(String name) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag child : this.children) {
            if (!child.getName().equals(name)) continue;
            result.add(child);
        }
        return result;
    }

    public List<Tag> getNamedChildrenWithAttribute(String tagName, String attrName, String attrValue) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag child : this.children) {
            if (!child.getName().equals(tagName) || !child.containsAttribute(attrName) || !child.getAttribute(attrName).equals(attrValue)) continue;
            result.add(child);
        }
        return result;
    }

    public Tag getParent() {
        return this.parent;
    }

    public void setParent(Tag parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public boolean containsAttribute(String name) {
        return this.attrs.containsKey(name);
    }

    public Map<String, String> getAttributes() {
        return this.attrs;
    }

    public String getAttribute(String name) {
        return this.attrs.get(name);
    }

    private int getDepth(Tag tag) {
        if (tag.getParent() != null) {
            return 1 + this.getDepth(tag.getParent());
        }
        return 0;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showChildren) {
        int i;
        StringBuilder builder = new StringBuilder();
        int myDepth = this.getDepth(this);
        for (i = 0; i < myDepth; ++i) {
            builder.append(INDENT);
        }
        builder.append('<').append(this.name);
        if (this.attrs.size() > 0) {
            for (Map.Entry<String, String> entry : this.attrs.entrySet()) {
                builder.append(' ').append(entry.getKey()).append('=').append('\"');
                builder.append(entry.getValue()).append('\"');
            }
        }
        if (this.selfClosing) {
            builder.append('/').append('>').append('\n');
        } else {
            if (showChildren && this.children.size() > 0) {
                builder.append('>').append('\n');
                for (Tag child : this.children) {
                    builder.append(child.toString());
                }
            } else {
                builder.append('>').append('\n');
                if (this.textContent != null) {
                    for (i = 0; i < myDepth; ++i) {
                        builder.append(INDENT);
                    }
                    builder.append(this.textContent).append('\n');
                }
            }
            for (int i2 = 0; i2 < myDepth; ++i2) {
                builder.append(INDENT);
            }
            builder.append('<').append('/');
            builder.append(this.name).append('>').append('\n');
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        if (this.selfClosing != tag.selfClosing) {
            return false;
        }
        if (this.attrs != null ? !this.attrs.equals(tag.attrs) : tag.attrs != null) {
            return false;
        }
        if (this.children != null ? !this.children.equals(tag.children) : tag.children != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(tag.name) : tag.name != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(tag.parent) : tag.parent != null) {
            return false;
        }
        return !(this.textContent != null ? !this.textContent.equals(tag.textContent) : tag.textContent != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.attrs != null ? this.attrs.hashCode() : 0);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + (this.selfClosing ? 1 : 0);
        result = 31 * result + (this.textContent != null ? this.textContent.hashCode() : 0);
        return result;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public void setFragment(boolean isFragment) {
        this.isFragment = isFragment;
    }
}

