/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import org.adoptopenjdk.jitwatch.model.EventType;
import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.util.StringUtil;

public class JITEvent {
    private long stamp;
    private EventType eventType;
    private IMetaMember eventMember;
    private String stampString;

    public JITEvent(long stamp, EventType eventType, IMetaMember eventMember) {
        this.stamp = stamp;
        this.eventType = eventType;
        this.eventMember = eventMember;
        this.stampString = StringUtil.formatTimestamp(stamp, true);
    }

    public long getStamp() {
        return this.stamp;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public IMetaMember getEventMember() {
        return this.eventMember;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.stampString).append(' ');
        sb.append(StringUtil.alignRight(this.eventType.getText(), 14)).append(' ').append(':').append(' ');
        sb.append(this.eventMember.toString());
        return sb.toString();
    }
}

