/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.loader;

import com.sun.tools.javap.JavapTask;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.MetaClass;
import org.adoptopenjdk.jitwatch.model.bytecode.BCParamConstant;
import org.adoptopenjdk.jitwatch.model.bytecode.BCParamNumeric;
import org.adoptopenjdk.jitwatch.model.bytecode.BCParamString;
import org.adoptopenjdk.jitwatch.model.bytecode.BCParamSwitch;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.ClassBC;
import org.adoptopenjdk.jitwatch.model.bytecode.IBytecodeParam;
import org.adoptopenjdk.jitwatch.model.bytecode.InnerClassRelationship;
import org.adoptopenjdk.jitwatch.model.bytecode.LineTableEntry;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;
import org.adoptopenjdk.jitwatch.model.bytecode.SourceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BytecodeLoader {
    private static final Logger logger = LoggerFactory.getLogger(BytecodeLoader.class);
    private static final Pattern PATTERN_BYTECODE_INSTRUCTION = Pattern.compile("^([0-9]+):\\s([0-9a-z_]+)\\s?([#0-9a-z,\\- ]+)?\\s?\\{?\\s?(//.*)?");
    private static final Map<String, BytecodeSection> sectionLabelMap = new HashMap<String, BytecodeSection>();

    private BytecodeLoader() {
    }

    public static MetaClass buildMetaClassFromClass(String fqClassName) {
        return null;
    }

    public static ClassBC fetchBytecodeForClass(List<String> classLocations, String fqClassName, boolean cacheBytecode) {
        String[] args = BytecodeLoader.buildClassPathFromClassLocations(classLocations, fqClassName);
        String byteCodeString = BytecodeLoader.createJavapTaskFromArguments(fqClassName, args);
        ClassBC classBytecode = BytecodeLoader.parseByteCodeFromString(fqClassName, byteCodeString, cacheBytecode);
        return classBytecode;
    }

    private static ClassBC parseByteCodeFromString(String fqClassName, String byteCodeString, boolean cacheBytecode) {
        ClassBC result = null;
        if (byteCodeString != null) {
            String[] bytecodeLines = byteCodeString.split("\n");
            try {
                result = BytecodeLoader.parse(fqClassName, bytecodeLines, cacheBytecode);
            }
            catch (Throwable t) {
                logger.error("Exception parsing bytecode", t);
            }
        }
        return result;
    }

    private static String createJavapTaskFromArguments(String fqClassName, String[] args) {
        String byteCodeString = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);){
            JavapTask task = new JavapTask();
            task.setLog(baos);
            task.handleOptions(args);
            task.call();
            byteCodeString = baos.toString();
        }
        catch (JavapTask.BadArgs ba) {
            logger.error("Could not obtain bytecode for class: {}", (Object)fqClassName, (Object)ba);
        }
        catch (IOException ioe) {
            logger.error("IOException in JavapTask", (Throwable)ioe);
        }
        return byteCodeString;
    }

    private static String[] buildClassPathFromClassLocations(Collection<String> classLocations, String fqClassName) {
        String[] args;
        if (classLocations == null || classLocations.size() == 0) {
            args = new String[]{"-c", "-p", "-v", fqClassName};
        } else {
            StringBuilder classPathBuilder = new StringBuilder();
            for (String cp : classLocations) {
                classPathBuilder.append(cp).append(File.pathSeparatorChar);
            }
            classPathBuilder.deleteCharAt(classPathBuilder.length() - 1);
            args = new String[]{"-c", "-p", "-v", "-classpath", classPathBuilder.toString(), fqClassName};
        }
        return args;
    }

    public static ClassBC parse(String fqClassName, String[] bytecodeLines, boolean cacheBytecode) {
        ClassBC classBytecode = new ClassBC(fqClassName);
        StringBuilder builder = new StringBuilder();
        BytecodeSection section = BytecodeSection.NONE;
        MemberSignatureParts msp = null;
        MemberBytecode memberBytecode = null;
        block10: for (int pos = 0; pos < bytecodeLines.length; ++pos) {
            String line = bytecodeLines[pos].trim();
            BytecodeSection nextSection = BytecodeLoader.getNextSection(line);
            if (nextSection != null) {
                BytecodeLoader.sectionFinished(fqClassName, section, msp, builder, memberBytecode, classBytecode);
                section = BytecodeLoader.changeSection(nextSection);
                if (++pos < bytecodeLines.length) {
                    line = bytecodeLines[pos].trim();
                }
            }
            switch (section) {
                case NONE: {
                    if (BytecodeLoader.couldBeMemberSignature(line)) {
                        msp = MemberSignatureParts.fromBytecodeSignature(fqClassName, line);
                        msp.setClassBC(classBytecode);
                        memberBytecode = new MemberBytecode(classBytecode, msp);
                        continue block10;
                    }
                    if (line.startsWith("Signature:")) {
                        BytecodeLoader.buildClassGenerics(line, classBytecode);
                        continue block10;
                    }
                    if (line.startsWith("minor version:")) {
                        int minorVersion = BytecodeLoader.getVersionPart(line);
                        if (minorVersion == -1) continue block10;
                        classBytecode.setMinorVersion(minorVersion);
                        continue block10;
                    }
                    if (line.startsWith("major version:")) {
                        int majorVersion = BytecodeLoader.getVersionPart(line);
                        if (majorVersion == -1) continue block10;
                        classBytecode.setMajorVersion(majorVersion);
                        continue block10;
                    }
                    if (!line.startsWith("SourceFile:")) continue block10;
                    classBytecode.setSourceFile(BytecodeLoader.getSourceFile(line));
                    if (!cacheBytecode) continue block10;
                    SourceMapper.addSourceClassMapping(classBytecode);
                    continue block10;
                }
                case INNERCLASSES: {
                    InnerClassRelationship icr = InnerClassRelationship.parse(line);
                    if (icr != null) {
                        if (!fqClassName.equals(icr.getParentClass())) continue block10;
                        classBytecode.addInnerClassName(icr.getChildClass());
                        continue block10;
                    }
                    section = BytecodeLoader.changeSection(BytecodeSection.NONE);
                    --pos;
                    continue block10;
                }
                case CODE: {
                    section = BytecodeLoader.performCODE(fqClassName, classBytecode, builder, section, msp, memberBytecode, line);
                    continue block10;
                }
                case CONSTANT_POOL: {
                    section = BytecodeLoader.performConstantPool(fqClassName, classBytecode, builder, section, msp, memberBytecode, line);
                    continue block10;
                }
                case LINETABLE: {
                    section = BytecodeLoader.performLINETABLE(fqClassName, classBytecode, builder, section, msp, memberBytecode, line);
                    continue block10;
                }
                case RUNTIMEVISIBLEANNOTATIONS: {
                    if (BytecodeLoader.isRunTimeVisibleAnnotation(line)) continue block10;
                    section = BytecodeLoader.changeSection(BytecodeSection.NONE);
                    --pos;
                    continue block10;
                }
                case LOCALVARIABLETABLE: {
                    if (BytecodeLoader.isLocalVariableLine(line)) continue block10;
                    section = BytecodeLoader.changeSection(BytecodeSection.NONE);
                    --pos;
                    continue block10;
                }
                case STACKMAPTABLE: {
                    if (BytecodeLoader.isStackMapTable(line)) continue block10;
                    section = BytecodeLoader.changeSection(BytecodeSection.NONE);
                    --pos;
                    continue block10;
                }
            }
        }
        return classBytecode;
    }

    public static void buildClassGenerics(String line, ClassBC classBytecode) {
        StringBuilder keyBuilder = new StringBuilder();
        StringBuilder valBuilder = new StringBuilder();
        boolean inKey = false;
        boolean inVal = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '<') {
                inKey = true;
                inVal = false;
                continue;
            }
            if (c == ':') {
                if (!inKey || inVal) continue;
                inKey = false;
                inVal = true;
                continue;
            }
            if (c == ';') {
                if (inKey || !inVal) continue;
                String key = keyBuilder.toString();
                String val = valBuilder.toString();
                if (val.length() > 0) {
                    val = val.substring(1);
                    val = val.replace("/", ".");
                }
                classBytecode.addGenericsMapping(key, val);
                keyBuilder.setLength(0);
                valBuilder.setLength(0);
                inKey = true;
                inVal = false;
                continue;
            }
            if (inKey) {
                keyBuilder.append(c);
                continue;
            }
            if (!inVal) continue;
            valBuilder.append(c);
        }
        if (!inKey && inVal) {
            String key = keyBuilder.toString();
            String val = valBuilder.toString();
            if (val.length() > 0) {
                val = val.substring(1);
                val = val.replace("/", ".");
            }
            classBytecode.addGenericsMapping(key, val);
            keyBuilder.setLength(0);
            valBuilder.setLength(0);
            inKey = false;
            inVal = false;
        }
    }

    private static BytecodeSection performLINETABLE(String fqClassName, ClassBC classBytecode, StringBuilder builder, BytecodeSection section, MemberSignatureParts msp, MemberBytecode memberBytecode, String line) {
        if (line.startsWith("line ")) {
            builder.append(line).append('\n');
        } else {
            BytecodeLoader.sectionFinished(fqClassName, BytecodeSection.LINETABLE, msp, builder, memberBytecode, classBytecode);
            section = BytecodeLoader.changeSection(BytecodeSection.NONE);
        }
        return section;
    }

    private static BytecodeSection performConstantPool(String fqClassName, ClassBC classBytecode, StringBuilder builder, BytecodeSection section, MemberSignatureParts msp, MemberBytecode memberBytecode, String line) {
        if (!line.startsWith("#")) {
            BytecodeLoader.sectionFinished(fqClassName, BytecodeSection.CONSTANT_POOL, msp, builder, memberBytecode, classBytecode);
            section = BytecodeLoader.changeSection(BytecodeSection.NONE);
        }
        return section;
    }

    private static BytecodeSection performCODE(String fqClassName, ClassBC classBytecode, StringBuilder builder, BytecodeSection section, MemberSignatureParts msp, MemberBytecode memberBytecode, String line) {
        block6: {
            int firstColonIndex = line.indexOf(58);
            if (firstColonIndex != -1) {
                String beforeColon = line.substring(0, firstColonIndex);
                try {
                    Integer.parseInt(beforeColon);
                    builder.append(line).append('\n');
                }
                catch (NumberFormatException nfe) {
                    if ("default".equals(beforeColon)) {
                        builder.append(line).append('\n');
                        break block6;
                    }
                    BytecodeLoader.sectionFinished(fqClassName, BytecodeSection.CODE, msp, builder, memberBytecode, classBytecode);
                    section = BytecodeLoader.changeSection(BytecodeSection.NONE);
                }
            } else if ("}".equals(line.trim())) {
                builder.append(line).append('\n');
            }
        }
        return section;
    }

    private static boolean isRunTimeVisibleAnnotation(String line) {
        return line.contains(": #");
    }

    private static boolean isLocalVariableLine(String line) {
        return line.startsWith("Start") || line.length() > 0 && Character.isDigit(line.charAt(0));
    }

    private static boolean isStackMapTable(String line) {
        String trimmedLine = line.trim();
        return trimmedLine.startsWith("frame_type") || trimmedLine.startsWith("offset_delta") || trimmedLine.startsWith("locals") || trimmedLine.startsWith("stack");
    }

    private static boolean couldBeMemberSignature(String line) {
        return line.endsWith(");") || line.contains(" throws ") && line.endsWith(";") || line.startsWith("static {}");
    }

    private static void sectionFinished(String fqClassName, BytecodeSection lastSection, MemberSignatureParts msp, StringBuilder builder, MemberBytecode memberBytecode, ClassBC classBytecode) {
        if (lastSection == BytecodeSection.CODE) {
            List<BytecodeInstruction> instructions = BytecodeLoader.parseInstructions(builder.toString());
            if (memberBytecode != null) {
                memberBytecode.setInstructions(instructions);
                classBytecode.addMemberBytecode(memberBytecode);
            } else {
                logger.error("No member for these instructions");
                for (BytecodeInstruction instr : instructions) {
                    logger.error("{}", (Object)instr);
                }
            }
        } else if (lastSection == BytecodeSection.LINETABLE) {
            BytecodeLoader.storeLineNumberTable(fqClassName, memberBytecode, builder.toString(), msp);
        }
        builder.delete(0, builder.length());
    }

    private static BytecodeSection changeSection(BytecodeSection nextSection) {
        return nextSection;
    }

    private static BytecodeSection getNextSection(String line) {
        BytecodeSection nextSection = null;
        if (line != null) {
            if (line.length() == 0) {
                nextSection = BytecodeSection.NONE;
            }
            for (Map.Entry<String, BytecodeSection> entry : sectionLabelMap.entrySet()) {
                if (!line.trim().startsWith(entry.getKey())) continue;
                nextSection = entry.getValue();
                break;
            }
        }
        return nextSection;
    }

    private static int getVersionPart(String line) {
        int version = -1;
        int colonPos = line.indexOf(58);
        if (colonPos != -1 && colonPos != line.length() - 1) {
            String versionPart = line.substring(colonPos + 1).trim();
            try {
                version = Integer.parseInt(versionPart);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return version;
    }

    private static String getSourceFile(String line) {
        String result = null;
        int colonPos = line.indexOf(58);
        if (colonPos != -1 && colonPos != line.length() - 1) {
            result = line.substring(colonPos + 1);
            result = result.replace("\"", "").trim();
        }
        return result;
    }

    public static List<BytecodeInstruction> parseInstructions(String bytecode) {
        ArrayList<BytecodeInstruction> bytecodeInstructions = new ArrayList<BytecodeInstruction>();
        String[] lines = bytecode.split("\n");
        boolean inSwitch = false;
        BCParamSwitch table = new BCParamSwitch();
        BytecodeInstruction instruction = null;
        for (String line : lines) {
            line = line.trim();
            if (inSwitch) {
                if ("}".equals(line)) {
                    instruction.addParameter(table);
                    bytecodeInstructions.add(instruction);
                    inSwitch = false;
                    continue;
                }
                String[] parts = line.split(":");
                if (parts.length == 2) {
                    table.put(parts[0].trim(), parts[1].trim());
                    continue;
                }
                logger.error("Unexpected tableswitch entry: " + line);
                continue;
            }
            try {
                Matcher matcher = PATTERN_BYTECODE_INSTRUCTION.matcher(line);
                if (matcher.find()) {
                    instruction = new BytecodeInstruction();
                    String offset = matcher.group(1);
                    String mnemonic = matcher.group(2);
                    String paramString = matcher.group(3);
                    String comment = matcher.group(4);
                    if (!(!mnemonic.endsWith("_w") || Opcode.GOTO_W.equals(mnemonic) || Opcode.JSR_W.equals(mnemonic) || Opcode.LDC_W.equals(mnemonic) || Opcode.LDC2_W.equals(mnemonic))) {
                        mnemonic = mnemonic.substring(0, mnemonic.length() - "_w".length());
                    }
                    instruction.setOffset(Integer.parseInt(offset));
                    instruction.setOpcode(Opcode.getOpcodeForMnemonic(mnemonic));
                    if (comment != null && comment.trim().length() > 0) {
                        instruction.setComment(comment.trim());
                    }
                    if (instruction.getOpcode() == Opcode.TABLESWITCH || instruction.getOpcode() == Opcode.LOOKUPSWITCH) {
                        inSwitch = true;
                        continue;
                    }
                    if (paramString != null && paramString.trim().length() > 0) {
                        BytecodeLoader.processParameters(paramString.trim(), instruction);
                    }
                    bytecodeInstructions.add(instruction);
                    continue;
                }
                logger.error("could not parse bytecode: '" + line + "'");
            }
            catch (Exception e) {
                logger.error("Error parsing bytecode line: '" + line + "'", (Throwable)e);
            }
        }
        return bytecodeInstructions;
    }

    private static void storeLineNumberTable(String fqClassName, MemberBytecode memberBytecode, String tableLines, MemberSignatureParts msp) {
        String[] lines;
        for (String line : lines = tableLines.split("\n")) {
            String[] parts = (line = line.trim().substring(5)).split(":");
            if (parts.length == 2) {
                String source = parts[0].trim();
                String offset = parts[1].trim();
                try {
                    LineTableEntry entry = new LineTableEntry(Integer.parseInt(source), Integer.parseInt(offset));
                    memberBytecode.addLineTableEntry(entry);
                }
                catch (NumberFormatException nfe) {
                    logger.error("Could not parse line number {}", (Object)line, (Object)nfe);
                }
                continue;
            }
            logger.error("Could not split line: {}", (Object)line);
        }
    }

    private static void processParameters(String paramString, BytecodeInstruction instruction) {
        String[] parts;
        for (String part : parts = paramString.split(",")) {
            IBytecodeParam parameter;
            if ((part = part.trim()).charAt(0) == '#') {
                parameter = new BCParamConstant(part);
            } else {
                try {
                    int value = Integer.parseInt(part);
                    parameter = new BCParamNumeric(value);
                }
                catch (NumberFormatException nfe) {
                    parameter = new BCParamString(part);
                }
            }
            instruction.addParameter(parameter);
        }
    }

    static {
        sectionLabelMap.put("Constant pool:", BytecodeSection.CONSTANT_POOL);
        sectionLabelMap.put("Code:", BytecodeSection.CODE);
        sectionLabelMap.put("LineNumberTable:", BytecodeSection.LINETABLE);
        sectionLabelMap.put("LocalVariableTable:", BytecodeSection.LOCALVARIABLETABLE);
        sectionLabelMap.put("RuntimeVisibleAnnotations:", BytecodeSection.RUNTIMEVISIBLEANNOTATIONS);
        sectionLabelMap.put("Exceptions:", BytecodeSection.EXCEPTIONS);
        sectionLabelMap.put("StackMapTable:", BytecodeSection.STACKMAPTABLE);
        sectionLabelMap.put("InnerClasses:", BytecodeSection.INNERCLASSES);
    }

    static enum BytecodeSection {
        NONE,
        CONSTANT_POOL,
        CODE,
        EXCEPTIONS,
        LINETABLE,
        RUNTIMEVISIBLEANNOTATIONS,
        LOCALVARIABLETABLE,
        STACKMAPTABLE,
        INNERCLASSES;

    }
}

