/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.sequencesearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.adoptopenjdk.jitwatch.jarscan.IJarScanOperation;
import org.adoptopenjdk.jitwatch.jarscan.sequencesearch.FoundSequence;
import org.adoptopenjdk.jitwatch.model.bytecode.BCParamNumeric;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;

public class SequenceSearchOperation
implements IJarScanOperation {
    private List<FoundSequence> matchingMethods = new ArrayList<FoundSequence>();
    private List<Opcode> chain = new LinkedList<Opcode>();
    private List<Opcode> wantedChain = new LinkedList<Opcode>();

    public SequenceSearchOperation(String sequence) {
        String[] searchSequence;
        for (String mnemonic : searchSequence = sequence.toLowerCase().split(",")) {
            Opcode opcode = Opcode.getOpcodeForMnemonic(mnemonic);
            this.wantedChain.add(opcode);
        }
    }

    private boolean compareChains() {
        boolean match = true;
        if (this.chain.size() == this.wantedChain.size()) {
            for (int i = 0; i < this.chain.size(); ++i) {
                Opcode wantOpcode;
                Opcode gotOpcode = this.chain.get(i);
                if (gotOpcode == (wantOpcode = this.wantedChain.get(i))) continue;
                match = false;
                break;
            }
        }
        return match;
    }

    public void reset() {
        this.chain.clear();
    }

    @Override
    public void processInstructions(String className, MemberBytecode memberBytecode) {
        this.reset();
        List<BytecodeInstruction> instructions = memberBytecode.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            boolean matched = this.handleChainStartingAtIndex(i, instructions);
            if (!matched) continue;
            BytecodeInstruction firstInstruction = instructions.get(i);
            int startingBCI = firstInstruction.getOffset();
            FoundSequence foundSequence = new FoundSequence(startingBCI, memberBytecode.getMemberSignatureParts());
            this.matchingMethods.add(foundSequence);
        }
    }

    private boolean handleChainStartingAtIndex(int index, List<BytecodeInstruction> instructions) {
        boolean stopChain = false;
        boolean abandonChain = false;
        boolean matched = false;
        HashSet<Integer> visitedBCI = new HashSet<Integer>();
        while (this.chain.size() < this.wantedChain.size()) {
            BytecodeInstruction instruction = instructions.get(index);
            int instrBCI = instruction.getOffset();
            visitedBCI.add(instrBCI);
            Opcode opcode = instruction.getOpcode();
            switch (opcode) {
                case IRETURN: 
                case LRETURN: 
                case FRETURN: 
                case DRETURN: 
                case ARETURN: 
                case RETURN: {
                    stopChain = true;
                    break;
                }
                case ATHROW: {
                    stopChain = true;
                    break;
                }
                case JSR: 
                case JSR_W: 
                case RET: {
                    abandonChain = true;
                    break;
                }
                case GOTO: 
                case GOTO_W: {
                    int gotoBCI = ((BCParamNumeric)instruction.getParameters().get(0)).getValue();
                    if (visitedBCI.contains(gotoBCI)) break;
                    index = this.getIndexForBCI(instructions, gotoBCI);
                    break;
                }
                default: {
                    ++index;
                }
            }
            this.chain.add(opcode);
            if (stopChain) {
                if (this.chain.size() == this.wantedChain.size()) {
                    matched = this.compareChains();
                }
                this.reset();
                break;
            }
            if (abandonChain) {
                this.reset();
                break;
            }
            if (this.chain.size() != this.wantedChain.size()) continue;
            matched = this.compareChains();
            this.reset();
            break;
        }
        return matched;
    }

    private int getIndexForBCI(List<BytecodeInstruction> instructions, int bci) {
        int index = -1;
        for (int i = 0; i < instructions.size(); ++i) {
            BytecodeInstruction instruction = instructions.get(i);
            if (instruction.getOffset() != bci) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public String getReport() {
        StringBuilder builder = new StringBuilder();
        Collections.sort(this.matchingMethods, new Comparator<FoundSequence>(){

            @Override
            public int compare(FoundSequence o1, FoundSequence o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (FoundSequence seq : this.matchingMethods) {
            builder.append("\"");
            builder.append(seq.getMemberSignatureParts().toStringSingleLine());
            builder.append("\"");
            builder.append(",");
            builder.append(seq.getStartingBCI());
            builder.append("\n");
        }
        return builder.toString();
    }
}

