/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.sequencecount;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.adoptopenjdk.jitwatch.jarscan.IJarScanOperation;
import org.adoptopenjdk.jitwatch.jarscan.sequencecount.InstructionSequence;
import org.adoptopenjdk.jitwatch.model.bytecode.BCParamNumeric;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;

public class SequenceCountOperation
implements IJarScanOperation {
    protected Map<InstructionSequence, Integer> chainCountMap = new TreeMap<InstructionSequence, Integer>();
    private List<Opcode> chain = new LinkedList<Opcode>();
    private int maxLength = 0;

    public SequenceCountOperation(int maxLength) {
        this.maxLength = maxLength;
    }

    private void storeChain() {
        InstructionSequence sequence = new InstructionSequence(this.chain);
        Integer count = this.chainCountMap.get(sequence);
        if (count == null) {
            this.chainCountMap.put(sequence, 1);
        } else {
            this.chainCountMap.put(sequence, count + 1);
        }
    }

    public Map<InstructionSequence, Integer> getSequenceScores() {
        return this.chainCountMap;
    }

    public List<Map.Entry<InstructionSequence, Integer>> getSortedData() {
        ArrayList<Map.Entry<InstructionSequence, Integer>> result = new ArrayList<Map.Entry<InstructionSequence, Integer>>(this.chainCountMap.entrySet());
        Collections.sort(result, new Comparator<Map.Entry<InstructionSequence, Integer>>(){

            @Override
            public int compare(Map.Entry<InstructionSequence, Integer> o1, Map.Entry<InstructionSequence, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        return result;
    }

    public int getCountForChain(String chain) {
        return this.chainCountMap.get(chain);
    }

    public void reset() {
        this.chain.clear();
    }

    @Override
    public void processInstructions(String className, MemberBytecode memberBytecode) {
        this.reset();
        List<BytecodeInstruction> instructions = memberBytecode.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            this.handleChainStartingAtIndex(i, instructions);
        }
    }

    private void handleChainStartingAtIndex(int index, List<BytecodeInstruction> instructions) {
        boolean stopChain = false;
        boolean abandonChain = false;
        HashSet<Integer> visitedBCI = new HashSet<Integer>();
        while (this.chain.size() < this.maxLength) {
            BytecodeInstruction instruction = instructions.get(index);
            int instrBCI = instruction.getOffset();
            visitedBCI.add(instrBCI);
            Opcode opcode = instruction.getOpcode();
            switch (opcode) {
                case IRETURN: 
                case LRETURN: 
                case FRETURN: 
                case DRETURN: 
                case ARETURN: 
                case RETURN: {
                    stopChain = true;
                    break;
                }
                case ATHROW: {
                    stopChain = true;
                    break;
                }
                case JSR: 
                case JSR_W: 
                case RET: {
                    abandonChain = true;
                    break;
                }
                case GOTO: 
                case GOTO_W: {
                    int gotoBCI = ((BCParamNumeric)instruction.getParameters().get(0)).getValue();
                    if (visitedBCI.contains(gotoBCI)) break;
                    index = this.getIndexForBCI(instructions, gotoBCI);
                    break;
                }
                default: {
                    ++index;
                }
            }
            this.chain.add(opcode);
            if (stopChain) {
                if (this.chain.size() == this.maxLength) {
                    this.storeChain();
                }
                this.reset();
                break;
            }
            if (abandonChain) {
                this.reset();
                break;
            }
            if (this.chain.size() != this.maxLength) continue;
            this.storeChain();
            this.reset();
            break;
        }
    }

    private int getIndexForBCI(List<BytecodeInstruction> instructions, int bci) {
        int index = -1;
        for (int i = 0; i < instructions.size(); ++i) {
            BytecodeInstruction instruction = instructions.get(i);
            if (instruction.getOffset() != bci) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public String getReport() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<InstructionSequence, Integer> entry : this.getSortedData()) {
            builder.append(entry.getKey().toString()).append(",").append(entry.getValue()).append("\n");
        }
        return builder.toString();
    }
}

