/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.allocationcount;

import java.util.EnumMap;
import java.util.Map;
import org.adoptopenjdk.jitwatch.jarscan.allocationcount.AllocCountMap;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;

public class InstructionAllocCountMap {
    private Map<Opcode, AllocCountMap> opcodeMap = new EnumMap<Opcode, AllocCountMap>(Opcode.class);

    public void count(Opcode opcode, String allocatedType) {
        AllocCountMap typeCountMap = this.opcodeMap.get(opcode);
        if (typeCountMap == null) {
            typeCountMap = new AllocCountMap();
            this.opcodeMap.put(opcode, typeCountMap);
        }
        typeCountMap.countAllocationOfType(allocatedType);
    }

    public String toString(int limitPerInvoke) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Opcode, AllocCountMap> entry : this.opcodeMap.entrySet()) {
            Opcode opcode = entry.getKey();
            AllocCountMap typeCountMap = entry.getValue();
            builder.append(typeCountMap.toString(opcode, limitPerInvoke));
        }
        return builder.toString();
    }
}

