/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StringUtil {
    private static final DecimalFormat DF_THOUSANDS = new DecimalFormat("#,###");

    private StringUtil() {
    }

    public static String formatTimestamp(long stamp, boolean showMillis) {
        long stampCopy = stamp;
        long dayMillis = 86400000L;
        long hourMillis = 3600000L;
        long minuteMillis = 60000L;
        long secondMillis = 1000L;
        long days = (long)Math.floor(stampCopy / dayMillis);
        long hours = (long)Math.floor((stampCopy -= days * dayMillis) / hourMillis);
        long minutes = (long)Math.floor((stampCopy -= hours * hourMillis) / minuteMillis);
        long seconds = (long)Math.floor((stampCopy -= minutes * minuteMillis) / secondMillis);
        long millis = stampCopy -= seconds * secondMillis;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        sb.append(StringUtil.padZero(hours, 2)).append(":");
        sb.append(StringUtil.padZero(minutes, 2)).append(":");
        sb.append(StringUtil.padZero(seconds, 2));
        if (showMillis) {
            sb.append(".").append(StringUtil.padZero(millis, 3));
        }
        return sb.toString();
    }

    public static String replaceXMLEntities(String input) {
        String result = null;
        if (input != null) {
            result = input.replace("&lt;", "<").replace("&gt;", ">").replace("&apos;", "'");
        }
        return result;
    }

    public static String repeat(char c, int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(c);
        }
        return builder.toString();
    }

    public static String rtrim(String string) {
        return string.replaceAll("\\s+$", "");
    }

    public static String alignRight(long num, int width) {
        return StringUtil.pad(Long.toString(num), width, ' ', true);
    }

    public static String alignRight(String str, int width) {
        return StringUtil.pad(str, width, ' ', true);
    }

    public static String alignLeft(long num, int width) {
        return StringUtil.pad(Long.toString(num), width, ' ', false);
    }

    public static String alignLeft(String str, int width) {
        return StringUtil.pad(str, width, ' ', false);
    }

    public static String padZero(long num, int width) {
        return StringUtil.pad(Long.toString(num), width, '0', true);
    }

    public static String pad(String str, int width, char padding, boolean left) {
        StringBuilder sb = new StringBuilder();
        if (str != null) {
            int len = str.length();
            if (!left) {
                sb.append(str);
            }
            if (len < width) {
                for (int i = 0; i < width - len; ++i) {
                    sb.append(padding);
                }
            }
            if (left) {
                sb.append(str);
            }
        }
        return sb.toString();
    }

    public static List<String> textToList(String text, String split) {
        ArrayList<String> result = new ArrayList<String>();
        if (text != null) {
            String[] lines;
            for (String line : lines = text.split(split)) {
                if (line.trim().length() <= 0) continue;
                result.add(line);
            }
        }
        return result;
    }

    public static String listToText(List<String> list, String join) {
        StringBuilder builder = new StringBuilder();
        for (String line : list) {
            builder.append(line).append(join);
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String getSubstringBetween(String input, String start, String end) {
        int endPos;
        int startPos = input.indexOf(start);
        String result = null;
        if (startPos != -1 && (endPos = input.indexOf(end, startPos + start.length())) != -1) {
            result = input.substring(startPos + start.length(), endPos);
        }
        return result;
    }

    public static String getUnqualifiedClassName(String fqClassName) {
        int lastDot = fqClassName.lastIndexOf(46);
        String result = fqClassName;
        if (lastDot != -1) {
            result = fqClassName.substring(lastDot + 1);
        }
        return result;
    }

    public static String getPackageName(String fqClassName) {
        int lastDot = fqClassName.lastIndexOf(46);
        String result = "";
        if (lastDot != -1) {
            result = fqClassName.substring(0, lastDot);
        }
        return result;
    }

    public static String padLineNumber(int number, int maxWidth) {
        return StringUtil.alignRight(Integer.toString(number), maxWidth);
    }

    public static Map<String, String> getLineAttributes(String line) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (line != null) {
            int len = line.length();
            StringBuilder key = new StringBuilder();
            StringBuilder val = new StringBuilder();
            boolean inValue = false;
            block5: for (int i = 0; i < len; ++i) {
                char c = line.charAt(i);
                switch (c) {
                    case ' ': {
                        if (!inValue) {
                            key.delete(0, key.length());
                            continue block5;
                        }
                        val.append(' ');
                        continue block5;
                    }
                    case '\'': {
                        if (inValue) {
                            result.put(key.toString(), val.toString());
                            key.delete(0, key.length());
                            val.delete(0, val.length());
                            inValue = false;
                            continue block5;
                        }
                        inValue = true;
                        continue block5;
                    }
                    case '=': {
                        if (!inValue) continue block5;
                        val.append('=');
                        continue block5;
                    }
                    default: {
                        if (inValue) {
                            val.append(c);
                            continue block5;
                        }
                        key.append(c);
                    }
                }
            }
        }
        return result;
    }

    public static Map<String, String> getLineAttributesDoubleQuote(String line) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (line != null) {
            int len = line.length();
            StringBuilder key = new StringBuilder();
            StringBuilder val = new StringBuilder();
            boolean inValue = false;
            block5: for (int i = 0; i < len; ++i) {
                char c = line.charAt(i);
                switch (c) {
                    case ' ': {
                        if (!inValue) {
                            key.delete(0, key.length());
                            continue block5;
                        }
                        val.append(' ');
                        continue block5;
                    }
                    case '\"': {
                        if (inValue) {
                            result.put(key.toString(), val.toString());
                            key.delete(0, key.length());
                            val.delete(0, val.length());
                            inValue = false;
                            continue block5;
                        }
                        inValue = true;
                        continue block5;
                    }
                    case '=': {
                        if (!inValue) continue block5;
                        val.append('=');
                        continue block5;
                    }
                    default: {
                        if (inValue) {
                            val.append(c);
                            continue block5;
                        }
                        key.append(c);
                    }
                }
            }
        }
        return result;
    }

    public static String formatThousands(String inValue) {
        String value = inValue;
        try {
            value = DF_THOUSANDS.format(Long.parseLong(value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public static String arrayToString(Object[] array) {
        return StringUtil.listToString(Arrays.asList(array), ' ');
    }

    public static String listToString(List<?> list) {
        return StringUtil.listToString(list, ' ');
    }

    public static String listToString(List<?> list, char separator) {
        StringBuilder builder = new StringBuilder();
        if (list != null) {
            for (Object item : list) {
                builder.append(item.toString()).append(separator);
            }
            if (builder.length() > 0) {
                builder.deleteCharAt(builder.length() - 1);
            }
        }
        return builder.toString();
    }

    public static String wordWrap(String text, int width) {
        StringBuilder builder = new StringBuilder(text);
        int i = 0;
        while (i + width < builder.length() && (i = builder.lastIndexOf(" ", i + width)) != -1) {
            builder.replace(i, i + 1, "\n");
        }
        return builder.toString();
    }

    public static String getAbbreviatedFQName(String fqClassName) {
        StringBuilder builder = new StringBuilder();
        if (fqClassName != null && fqClassName.length() > 0) {
            String[] parts = fqClassName.split("\\.");
            for (int i = 0; i < parts.length - 1; ++i) {
                String part = parts[i];
                builder.append(part.charAt(0)).append('.');
            }
            builder.append(parts[parts.length - 1]);
        }
        return builder.toString();
    }

    public static List<String> getSortedKeys(Map<String, ?> map) {
        ArrayList<String> attrList = new ArrayList<String>(map.keySet());
        Collections.sort(attrList);
        return attrList;
    }
}

