/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.assembly;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyBlock;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyInstruction;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyLabels;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssemblyUtil {
    private static final Logger logger = LoggerFactory.getLogger(AssemblyUtil.class);
    private static final Pattern PATTERN_ASSEMBLY_INSTRUCTION = Pattern.compile("^(0x[a-f0-9]+):\\s+([0-9a-z\\(\\)\\$,\\-%\\s]+)([;#].*)?");

    private AssemblyUtil() {
    }

    public static AssemblyMethod parseAssembly(String asm) {
        AssemblyMethod method = new AssemblyMethod();
        AssemblyLabels labels = new AssemblyLabels();
        String[] lines = asm.split("\n");
        StringBuilder headerBuilder = new StringBuilder();
        AssemblyBlock currentBlock = new AssemblyBlock();
        AssemblyInstruction lastInstruction = null;
        String lastLine = null;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].replace("&apos;", "'");
            if ((line = line.replaceFirst("^ +", "")).startsWith("#")) {
                headerBuilder.append(line).append("\n");
            } else if (line.startsWith("[")) {
                method.addBlock(currentBlock);
                currentBlock = new AssemblyBlock();
                currentBlock.setTitle(line);
            } else if (line.startsWith(";")) {
                if (lastInstruction != null) {
                    lastInstruction.addCommentLine(line);
                }
            } else {
                AssemblyInstruction instr = AssemblyUtil.createInstruction(labels, line);
                if (instr == null && lastLine.trim().startsWith("#") && !line.startsWith("0x") && !line.contains(" 0x")) {
                    headerBuilder.setLength(headerBuilder.length() - "\n".length());
                    headerBuilder.append(line).append("\n");
                    line = lastLine + line;
                } else if (instr == null && lastLine.trim().startsWith(";") && lastInstruction != null) {
                    lastInstruction.appendToLastCommentLine(line);
                    line = lastLine + line;
                } else {
                    boolean replaceLast = false;
                    if (instr == null && i < lines.length - 1) {
                        String nextUntrimmedLine = lines[i + 1].replace("&apos;", "'");
                        instr = AssemblyUtil.createInstruction(labels, line + nextUntrimmedLine);
                        if (instr != null) {
                            ++i;
                        }
                    }
                    if (instr == null && lastInstruction != null && (instr = AssemblyUtil.createInstruction(labels, lastLine + line)) != null) {
                        replaceLast = true;
                    }
                    if (instr != null) {
                        if (replaceLast) {
                            currentBlock.replaceLastInstruction(instr);
                        } else {
                            currentBlock.addInstruction(instr);
                        }
                        lastInstruction = instr;
                    } else {
                        logger.error("Could not parse assembly: {}", (Object)line);
                    }
                }
            }
            lastLine = line;
        }
        method.addBlock(currentBlock);
        method.setHeader(headerBuilder.toString());
        labels.buildLabels();
        return method;
    }

    public static AssemblyInstruction createInstruction(AssemblyLabels labels, String inLine) {
        Matcher matcher;
        int addressIndex;
        String line = inLine;
        AssemblyInstruction instr = null;
        String annotation = "";
        if (!line.startsWith("0x") && (addressIndex = line.indexOf(" 0x")) != -1) {
            annotation = line.substring(0, addressIndex) + ' ';
            line = line.substring(addressIndex + 1);
        }
        if ((matcher = PATTERN_ASSEMBLY_INSTRUCTION.matcher(line)).find() && matcher.groupCount() == 3) {
            String address = matcher.group(1);
            String instructionString = matcher.group(2);
            String comment = matcher.group(3);
            long addressValue = AssemblyUtil.getValueFromAddress(address);
            String modifier = null;
            String mnemonic = null;
            ArrayList<String> operands = new ArrayList<String>();
            if (instructionString != null) {
                String[] midParts = instructionString.trim().split("\\s+");
                String opString = null;
                if (midParts.length == 1) {
                    mnemonic = midParts[0];
                } else if (midParts.length == 2) {
                    mnemonic = midParts[0];
                    opString = midParts[1];
                } else if (midParts.length >= 3) {
                    modifier = AssemblyUtil.getModForThreeOrMoreOperands(midParts);
                    mnemonic = midParts[midParts.length - 2];
                    opString = midParts[midParts.length - 1];
                } else {
                    logger.error("Don't know how to parse this: {} {}", (Object)line, (Object)midParts.length);
                }
                AssemblyUtil.addValidOperandsToList(operands, opString);
                instr = new AssemblyInstruction(annotation, addressValue, modifier, mnemonic, operands, comment, labels);
                labels.newInstruction(instr);
            }
        }
        return instr;
    }

    static long getValueFromAddress(String address) {
        long addressValue = 0L;
        if (address != null) {
            String trimmedAddress = address.trim();
            if (trimmedAddress.startsWith("0x")) {
                trimmedAddress = trimmedAddress.substring("0x".length());
            }
            if (trimmedAddress.endsWith("h")) {
                trimmedAddress = trimmedAddress.substring(0, trimmedAddress.length() - 1);
            }
            addressValue = Long.parseLong(trimmedAddress, 16);
        }
        return addressValue;
    }

    private static void addValidOperandsToList(List<String> operands, String opString) {
        if (opString != null) {
            StringBuilder opBuilder = new StringBuilder();
            boolean inParentheses = false;
            for (int pos = 0; pos < opString.length(); ++pos) {
                char c = opString.charAt(pos);
                if (c == '(') {
                    inParentheses = true;
                    opBuilder.append(c);
                    continue;
                }
                if (c == ')') {
                    inParentheses = false;
                    opBuilder.append(c);
                    continue;
                }
                if (c == ',' && !inParentheses) {
                    String operand = opBuilder.toString();
                    opBuilder.delete(0, opBuilder.length());
                    operands.add(operand);
                    continue;
                }
                opBuilder.append(c);
            }
            if (opBuilder.length() > 0) {
                String operand = opBuilder.toString();
                opBuilder.delete(0, opBuilder.length() - 1);
                operands.add(operand);
            }
        }
    }

    private static String getModForThreeOrMoreOperands(String[] midParts) {
        StringBuilder modBuilder = new StringBuilder();
        for (int i = 0; i < midParts.length - 2; ++i) {
            modBuilder.append(midParts[i]).append(" ");
        }
        return modBuilder.toString().trim();
    }
}

