/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.assembly;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyInstruction;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyUtil;
import org.adoptopenjdk.jitwatch.util.StringUtil;

public final class AssemblyLabels {
    private SortedSet<Long> addresses = new TreeSet<Long>();
    private final Map<Long, Short> labels = new HashMap<Long, Short>();
    private long lowest = Long.MAX_VALUE;
    private long highest;

    public void newInstruction(AssemblyInstruction instruction) {
        long address = instruction.getAddress();
        this.lowest = Math.min(this.lowest, address);
        this.highest = Math.max(this.highest, address);
        Long l = this.instructionToLabel(instruction);
        if (l != null) {
            this.addresses.add(l);
        }
    }

    private Long instructionToLabel(AssemblyInstruction instruction) {
        List<String> operands = instruction.getOperands();
        if (instruction.getMnemonic().startsWith("j") && operands.size() == 1) {
            return AssemblyUtil.getValueFromAddress(operands.get(0));
        }
        return null;
    }

    public void buildLabels() {
        short next = 0;
        if (this.lowest != Long.MAX_VALUE) {
            for (Long a : this.addresses.subSet(this.lowest, this.highest + 1L)) {
                short s = next;
                next = (short)(next + 1);
                this.labels.put(a, s);
            }
        }
        this.addresses = null;
    }

    public void formatAddress(long address, StringBuilder builder) {
        Short label = this.labels.get(address);
        if (label != null) {
            builder.append(StringUtil.pad(String.format("L%04x", label), 18, ' ', true));
        } else {
            builder.append("0x");
            builder.append(StringUtil.pad(Long.toHexString(address), 16, '0', true));
        }
    }

    public void formatOperands(AssemblyInstruction instruction, StringBuilder builder) {
        Long address = this.instructionToLabel(instruction);
        Short label = this.labels.get(address);
        if (label != null) {
            builder.append(' ');
            builder.append(String.format("L%04x", label));
        } else {
            List<String> operands = instruction.getOperands();
            if (operands.size() > 0) {
                builder.append(' ');
                for (String op : operands) {
                    builder.append(op).append(",");
                }
                builder.deleteCharAt(builder.length() - 1);
            }
        }
    }
}

