/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.journal;

import java.util.List;
import org.adoptopenjdk.jitwatch.journal.IJournalVisitable;
import org.adoptopenjdk.jitwatch.model.CompilerName;
import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.model.IParseDictionary;
import org.adoptopenjdk.jitwatch.model.Journal;
import org.adoptopenjdk.jitwatch.model.LogParseException;
import org.adoptopenjdk.jitwatch.model.Tag;
import org.adoptopenjdk.jitwatch.model.Task;
import org.adoptopenjdk.jitwatch.util.ParseUtil;
import org.adoptopenjdk.jitwatch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JournalUtil {
    private static final Logger logger = LoggerFactory.getLogger(JournalUtil.class);
    private static int unhandledTagCount = 0;

    private JournalUtil() {
    }

    public static void visitParseTagsOfLastTask(Journal journal, IJournalVisitable visitable) throws LogParseException {
        block3: {
            Task lastTask;
            block2: {
                lastTask = JournalUtil.getLastTask(journal);
                if (lastTask != null) break block2;
                if (JournalUtil.isJournalForCompile2NativeMember(journal)) break block3;
                logger.warn("No Task found in Journal");
                if (journal == null || journal.getEntryList().size() <= 0) break block3;
                logger.warn(journal.toString());
                break block3;
            }
            IParseDictionary parseDictionary = lastTask.getParseDictionary();
            Tag parsePhase = JournalUtil.getParsePhase(lastTask);
            if (parsePhase != null) {
                List<Tag> parseTags = parsePhase.getNamedChildren("parse");
                for (Tag parseTag : parseTags) {
                    visitable.visitTag(parseTag, parseDictionary);
                }
            }
        }
    }

    public static void visitOptimizerTagsOfLastTask(Journal journal, IJournalVisitable visitable) throws LogParseException {
        block3: {
            Task lastTask;
            block2: {
                lastTask = JournalUtil.getLastTask(journal);
                if (lastTask != null) break block2;
                if (JournalUtil.isJournalForCompile2NativeMember(journal)) break block3;
                logger.warn("No Task found in Journal");
                if (journal == null || journal.getEntryList().size() <= 0) break block3;
                logger.warn(journal.toString());
                break block3;
            }
            IParseDictionary parseDictionary = lastTask.getParseDictionary();
            Tag optimizerPhase = JournalUtil.getOptimizerPhase(lastTask);
            if (optimizerPhase != null) {
                for (Tag child : optimizerPhase.getChildren()) {
                    visitable.visitTag(child, parseDictionary);
                }
            }
        }
    }

    public static boolean isJournalForCompile2NativeMember(Journal journal) {
        Tag tag;
        String tagName;
        List<Tag> entryList;
        boolean result = false;
        if (journal != null && (entryList = journal.getEntryList()).size() >= 1 && "nmethod".equals(tagName = (tag = entryList.get(0)).getName()) && "c2n".equals(tag.getAttribute("compile_kind"))) {
            result = true;
        }
        return result;
    }

    public static boolean memberMatchesKlassID(IMetaMember member, String klassID, IParseDictionary parseDictionary) {
        boolean result = false;
        String klassName = ParseUtil.lookupType(klassID, parseDictionary);
        String memberClassName = member.getMetaClass().getFullyQualifiedName();
        result = memberClassName.equals(klassName);
        return result;
    }

    public static boolean memberMatchesMethodID(IMetaMember member, String methodID, IParseDictionary parseDictionary) {
        String klassID;
        Tag klassTag;
        boolean result = false;
        Tag methodTag = parseDictionary.getMethod(methodID);
        if (methodTag != null && (klassTag = parseDictionary.getKlass(klassID = methodTag.getAttribute("holder"))) != null) {
            String klassAttrName = klassTag.getAttribute("name");
            String methodAttrName = StringUtil.replaceXMLEntities(methodTag.getAttribute("name"));
            if (klassAttrName != null) {
                klassAttrName = klassAttrName.replace('/', '.');
            }
            String returnType = ParseUtil.getMethodTagReturn(methodTag, parseDictionary);
            List<String> paramTypes = ParseUtil.getMethodTagArguments(methodTag, parseDictionary);
            boolean nameMatches = "<init>".equals(methodAttrName) ? member.getMemberName().equals(klassAttrName) : member.getMemberName().equals(methodAttrName);
            boolean klassMatches = member.getMetaClass().getFullyQualifiedName().equals(klassAttrName);
            boolean returnMatches = member.getReturnTypeName().equals(returnType);
            boolean paramsMatch = true;
            if (member.getParamTypeNames().length == paramTypes.size()) {
                for (int pos = 0; pos < member.getParamTypeNames().length; ++pos) {
                    String tagParamType;
                    String memberParamType = member.getParamTypeNames()[pos];
                    if (memberParamType.equals(tagParamType = paramTypes.get(pos))) continue;
                    paramsMatch = false;
                    break;
                }
            } else {
                paramsMatch = false;
            }
            result = nameMatches && klassMatches && returnMatches && paramsMatch;
        }
        return result;
    }

    public static Task getLastTask(Journal journal) {
        Task lastTask = null;
        if (journal != null) {
            for (Tag tag : journal.getEntryList()) {
                if (!(tag instanceof Task)) continue;
                lastTask = (Task)tag;
            }
        }
        return lastTask;
    }

    public static CompilerName getCompilerNameForLastTask(Journal journal) {
        Task lastTask = JournalUtil.getLastTask(journal);
        CompilerName compilerName = null;
        if (lastTask != null) {
            compilerName = lastTask.getCompiler();
        }
        return compilerName;
    }

    private static Tag getParsePhase(Task lastTask) {
        Tag parsePhase = null;
        if (lastTask != null) {
            List<Tag> parsePhases;
            int count;
            CompilerName compilerName = lastTask.getCompiler();
            String parseAttributeName = "parse";
            if (compilerName == CompilerName.C1) {
                parseAttributeName = "buildIR";
            }
            if ((count = (parsePhases = lastTask.getNamedChildrenWithAttribute("phase", "name", parseAttributeName)).size()) > 1) {
                logger.warn("Unexpected parse phase count: {}", (Object)count);
                logger.warn("\n{}", (Object)lastTask.toString(true));
            } else {
                parsePhase = count == 1 ? parsePhases.get(0) : lastTask;
            }
        }
        return parsePhase;
    }

    private static Tag getOptimizerPhase(Task lastTask) {
        Tag optimizerPhase = null;
        if (lastTask != null) {
            List<Tag> parsePhases = lastTask.getNamedChildrenWithAttribute("phase", "name", "optimizer");
            int count = parsePhases.size();
            if (count > 1) {
                logger.warn("Unexpected optimizer phase count: {}", (Object)count);
            } else if (count == 1) {
                optimizerPhase = parsePhases.get(0);
            }
        }
        return optimizerPhase;
    }

    public static void unhandledTag(IJournalVisitable visitable, Tag child) {
        ++unhandledTagCount;
        logger.warn("{} did not handle {}", (Object)visitable.getClass().getName(), (Object)child.toString(false));
    }

    public static int getUnhandledTagCount() {
        return unhandledTagCount;
    }
}

