/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.adoptopenjdk.jitwatch.loader.BytecodeLoader;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.ClassBC;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;

public final class JarScan {
    private JarScan() {
    }

    public static void iterateJar(File jarFile, int maxMethodBytes, PrintWriter writer) throws IOException {
        ArrayList<String> classLocations = new ArrayList<String>();
        classLocations.add(jarFile.getPath());
        try (ZipFile zip = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> list = zip.entries();
            while (list.hasMoreElements()) {
                ZipEntry entry = list.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                String fqName = name.replace("/", ".").substring(0, name.length() - 6);
                JarScan.process(classLocations, fqName, maxMethodBytes, writer);
            }
        }
    }

    private static void process(List<String> classLocations, String className, int maxMethodBytes, PrintWriter writer) {
        ClassBC classBytecode = BytecodeLoader.fetchBytecodeForClass(classLocations, className);
        if (classBytecode != null) {
            for (MemberBytecode memberBytecode : classBytecode.getMemberBytecodeList()) {
                List<BytecodeInstruction> instructions = memberBytecode.getInstructions();
                if (instructions == null || instructions.size() <= 0) continue;
                BytecodeInstruction lastInstruction = instructions.get(instructions.size() - 1);
                int bcSize = 1 + lastInstruction.getOffset();
                MemberSignatureParts msp = memberBytecode.getMemberSignatureParts();
                if (bcSize < maxMethodBytes || "<clinit>".equals(msp.getMemberName())) continue;
                writer.print('\"');
                writer.print(className);
                writer.print('\"');
                writer.print(',');
                writer.print('\"');
                writer.print(msp.getMemberName());
                writer.print('\"');
                writer.print(',');
                writer.print(bcSize);
                writer.println();
                writer.flush();
            }
        } else {
            System.err.println("An error occurred while parsing " + className + ". Please see jitwatch.out for details");
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws IOException {
        int maxMethodBytes = Integer.getInteger("maxMethodSize", 325);
        PrintWriter writer = new PrintWriter(System.out);
        for (String jar : args) {
            File jarFile = new File(jar);
            writer.print(jarFile.getAbsolutePath());
            writer.println(':');
            JarScan.iterateJar(jarFile, maxMethodBytes, writer);
            writer.println();
        }
        writer.flush();
        writer.close();
    }
}

