/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.graph.NodeRenderer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.artifact.Artifact;

public class JsonDependencyNodeNameRenderer
implements NodeRenderer<DependencyNode> {
    private final boolean showGroupId;
    private final boolean showArtifactId;
    private final boolean showTypes;
    private final boolean showClassifiers;
    private final boolean showVersion;
    private final boolean showOptional;
    private final boolean showScope;
    private final ObjectMapper objectMapper;

    public JsonDependencyNodeNameRenderer(boolean showGroupId, boolean showArtifactId, boolean showTypes, boolean showClassifiers, boolean showVersion, boolean showOptional, boolean showScope) {
        this.showGroupId = showGroupId;
        this.showArtifactId = showArtifactId;
        this.showTypes = showTypes;
        this.showClassifiers = showClassifiers;
        this.showVersion = showVersion;
        this.showOptional = showOptional;
        this.showScope = showScope;
        this.objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    @Override
    public String render(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        ArtifactData artifactData = new ArtifactData(this.showGroupId ? artifact.getGroupId() : null, this.showArtifactId ? artifact.getArtifactId() : null, this.showVersion ? node.getEffectiveVersion() : null, this.showOptional ? Boolean.valueOf(artifact.isOptional()) : null, this.showClassifiers ? node.getClassifiers() : Collections.emptyList(), this.showScope ? (!node.getScopes().isEmpty() ? node.getScopes() : Collections.singletonList("compile")) : Collections.emptyList(), this.showTypes ? node.getTypes() : Collections.emptyList());
        StringWriter jsonStringWriter = new StringWriter();
        try {
            this.objectMapper.writer().writeValue((Writer)jsonStringWriter, (Object)artifactData);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return jsonStringWriter.toString();
    }

    private static class ArtifactData {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Boolean optional;
        private final Collection<String> classifiers;
        private final Collection<String> scopes;
        private final Collection<String> types;

        ArtifactData(String groupId, String artifactId, String version, Boolean optional, Collection<String> classifiers, Collection<String> scopes, Collection<String> types) {
            this.optional = optional;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.classifiers = classifiers;
            this.scopes = scopes;
            this.types = types;
        }
    }
}

