/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fernandospr.wns.client;

import ar.com.fernandospr.wns.model.WnsAbstractNotification;
import ar.com.fernandospr.wns.model.WnsNotificationRequestOptional;
import com.sun.jersey.api.client.WebResource;

public abstract class WnsResourceBuilder {
    public WebResource.Builder build(WebResource webResource, WnsAbstractNotification notification, String token, WnsNotificationRequestOptional optional) {
        WebResource.Builder webResourceBuilder = webResource.getRequestBuilder();
        this.addRequiredHeaders(webResourceBuilder, notification.getType(), token);
        this.addOptionalHeaders(webResourceBuilder, optional);
        webResourceBuilder.entity(this.getEntityToSendWithNotification(notification));
        return webResourceBuilder;
    }

    protected abstract Object getEntityToSendWithNotification(WnsAbstractNotification var1);

    protected void addOptionalHeaders(WebResource.Builder webResourceBuilder, WnsNotificationRequestOptional optional) {
        if (optional != null) {
            if (!this.emptyString(optional.cachePolicy)) {
                webResourceBuilder.header("X-WNS-Cache-Policy", (Object)optional.cachePolicy);
            }
            if (!this.emptyString(optional.requestForStatus)) {
                webResourceBuilder.header("X-WNS-RequestForStatus", (Object)optional.requestForStatus);
            }
            if (!this.emptyString(optional.tag)) {
                webResourceBuilder.header("X-WNS-Tag", (Object)optional.tag);
            }
            if (!this.emptyString(optional.ttl)) {
                webResourceBuilder.header("X-WNS-TTL", (Object)optional.ttl);
            }
        }
    }

    protected void addRequiredHeaders(WebResource.Builder webResourceBuilder, String type, String accessToken) {
        if (type.equalsIgnoreCase("wns/raw")) {
            webResourceBuilder.type("application/octet-stream");
        } else {
            webResourceBuilder.type("text/xml");
        }
        ((WebResource.Builder)webResourceBuilder.header("X-WNS-Type", (Object)type)).header("Authorization", (Object)("Bearer " + accessToken));
    }

    private boolean emptyString(String str) {
        return str == null || str.isEmpty();
    }
}

