/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fernandospr.wns.client;

import ar.com.fernandospr.wns.WnsProxyProperties;
import ar.com.fernandospr.wns.client.WnsResourceBuilder;
import ar.com.fernandospr.wns.exceptions.WnsException;
import ar.com.fernandospr.wns.model.WnsAbstractNotification;
import ar.com.fernandospr.wns.model.WnsNotificationRequestOptional;
import ar.com.fernandospr.wns.model.WnsNotificationResponse;
import ar.com.fernandospr.wns.model.WnsOAuthToken;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.httpclient.auth.AuthScope;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WnsClient {
    private static final String SCOPE = "notify.windows.com";
    private static final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    private static final String AUTHENTICATION_URI = "https://login.live.com/accesstoken.srf";
    private String sid;
    private String clientSecret;
    private WnsOAuthToken token;
    private Client client;

    public WnsClient(String sid, String clientSecret, boolean logging) {
        this.sid = sid;
        this.clientSecret = clientSecret;
        this.client = WnsClient.createClient(logging);
    }

    public WnsClient(String sid, String clientSecret, WnsProxyProperties proxyProps, boolean logging) {
        this.sid = sid;
        this.clientSecret = clientSecret;
        this.client = WnsClient.createClient(logging, proxyProps);
    }

    private static Client createClient(boolean logging) {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(JacksonJsonProvider.class);
        Client client = Client.create((ClientConfig)clientConfig);
        if (logging) {
            client.addFilter((ClientFilter)new LoggingFilter(System.out));
        }
        return client;
    }

    private static Client createClient(boolean logging, WnsProxyProperties proxyProps) {
        DefaultApacheHttpClientConfig clientConfig = new DefaultApacheHttpClientConfig();
        WnsClient.setProxyCredentials(clientConfig, proxyProps);
        clientConfig.getClasses().add(JacksonJsonProvider.class);
        ApacheHttpClient client = ApacheHttpClient.create((ClientConfig)clientConfig);
        if (logging) {
            client.addFilter((ClientFilter)new LoggingFilter(System.out));
        }
        return client;
    }

    private static void setProxyCredentials(DefaultApacheHttpClientConfig clientConfig, WnsProxyProperties proxyProps) {
        if (proxyProps != null) {
            String proxyProtocol = proxyProps.getProtocol();
            String proxyHost = proxyProps.getHost();
            int proxyPort = proxyProps.getPort();
            String proxyUser = proxyProps.getUser();
            String proxyPass = proxyProps.getPass();
            if (proxyHost != null && !proxyHost.trim().isEmpty()) {
                clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", proxyProtocol + "://" + proxyHost + ":" + proxyPort);
                if (!proxyUser.trim().isEmpty()) {
                    clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.preemptiveAuthentication", true);
                    clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.interactive", true);
                    clientConfig.getState().setCredentials(AuthScope.ANY_REALM, AuthScope.ANY_HOST, -1, proxyUser, proxyPass);
                    clientConfig.getState().setProxyCredentials(AuthScope.ANY_REALM, proxyHost, proxyPort, proxyUser, proxyPass);
                }
            }
        }
    }

    public void refreshAccessToken() throws WnsException {
        WebResource webResource = this.client.resource(AUTHENTICATION_URI);
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)"grant_type", (Object)GRANT_TYPE_CLIENT_CREDENTIALS);
        formData.add((Object)"client_id", (Object)this.sid);
        formData.add((Object)"client_secret", (Object)this.clientSecret);
        formData.add((Object)"scope", (Object)SCOPE);
        ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).post(ClientResponse.class, (Object)formData);
        if (response.getStatus() != 200) {
            throw new WnsException("Authentication failed. HTTP error code: " + response.getStatus());
        }
        this.token = (WnsOAuthToken)response.getEntity(WnsOAuthToken.class);
    }

    public WnsNotificationResponse push(WnsResourceBuilder resourceBuilder, String channelUri, WnsAbstractNotification notification, int retriesLeft, WnsNotificationRequestOptional optional) throws WnsException {
        WebResource webResource = this.client.resource(channelUri);
        WebResource.Builder webResourceBuilder = resourceBuilder.build(webResource, notification, this.getToken().access_token, optional);
        ClientResponse response = (ClientResponse)webResourceBuilder.post(ClientResponse.class);
        WnsNotificationResponse notificationResponse = new WnsNotificationResponse(channelUri, response.getStatus(), (MultivaluedMap<String, String>)response.getHeaders());
        if (notificationResponse.code == 200) {
            return notificationResponse;
        }
        if (notificationResponse.code == 401 && retriesLeft > 0) {
            this.refreshAccessToken();
            return this.push(resourceBuilder, channelUri, notification, --retriesLeft, optional);
        }
        return notificationResponse;
    }

    private WnsOAuthToken getToken() throws WnsException {
        if (this.token == null) {
            this.refreshAccessToken();
        }
        return this.token;
    }

    public List<WnsNotificationResponse> push(WnsResourceBuilder resourceBuilder, List<String> channelUris, WnsAbstractNotification notification, int retriesLeft, WnsNotificationRequestOptional optional) throws WnsException {
        ArrayList<WnsNotificationResponse> responses = new ArrayList<WnsNotificationResponse>();
        for (String channelUri : channelUris) {
            WnsNotificationResponse response = this.push(resourceBuilder, channelUri, notification, retriesLeft, optional);
            responses.add(response);
        }
        return responses;
    }
}

