/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fernandospr.wns;

import ar.com.fernandospr.wns.WnsProxyProperties;
import ar.com.fernandospr.wns.client.WnsClient;
import ar.com.fernandospr.wns.client.WnsRawResourceBuilder;
import ar.com.fernandospr.wns.client.WnsResourceBuilder;
import ar.com.fernandospr.wns.client.WnsXmlResourceBuilder;
import ar.com.fernandospr.wns.exceptions.WnsException;
import ar.com.fernandospr.wns.model.WnsAbstractNotification;
import ar.com.fernandospr.wns.model.WnsBadge;
import ar.com.fernandospr.wns.model.WnsNotificationRequestOptional;
import ar.com.fernandospr.wns.model.WnsNotificationResponse;
import ar.com.fernandospr.wns.model.WnsRaw;
import ar.com.fernandospr.wns.model.WnsTile;
import ar.com.fernandospr.wns.model.WnsToast;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WnsService {
    private int retryPolicy = 5;
    private WnsClient client;
    private WnsResourceBuilder xmlResourceBuilder;
    private WnsResourceBuilder rawResourceBuilder;

    public WnsService(String sid, String clientSecret) {
        this(sid, clientSecret, false);
    }

    public WnsService(String sid, String clientSecret, WnsProxyProperties proxyProperties) {
        this(sid, clientSecret, proxyProperties, false);
    }

    public WnsService(String sid, String clientSecret, WnsProxyProperties proxyProperties, boolean logging) {
        this.client = new WnsClient(sid, clientSecret, proxyProperties, logging);
        this.xmlResourceBuilder = new WnsXmlResourceBuilder();
        this.rawResourceBuilder = new WnsRawResourceBuilder();
    }

    public WnsService(String sid, String clientSecret, boolean logging) {
        this.client = new WnsClient(sid, clientSecret, logging);
        this.xmlResourceBuilder = new WnsXmlResourceBuilder();
        this.rawResourceBuilder = new WnsRawResourceBuilder();
    }

    public WnsNotificationResponse pushTile(String channelUri, WnsTile tile) throws WnsException {
        return this.pushTile(channelUri, null, tile);
    }

    public WnsNotificationResponse pushTile(String channelUri, WnsNotificationRequestOptional optional, WnsTile tile) throws WnsException {
        return this.client.push(this.xmlResourceBuilder, channelUri, (WnsAbstractNotification)tile, this.retryPolicy, optional);
    }

    public List<WnsNotificationResponse> pushTile(List<String> channelUris, WnsTile tile) throws WnsException {
        return this.pushTile(channelUris, null, tile);
    }

    public List<WnsNotificationResponse> pushTile(List<String> channelUris, WnsNotificationRequestOptional optional, WnsTile tile) throws WnsException {
        return this.client.push(this.xmlResourceBuilder, channelUris, (WnsAbstractNotification)tile, this.retryPolicy, optional);
    }

    public WnsNotificationResponse pushToast(String channelUri, WnsToast toast) throws WnsException {
        return this.pushToast(channelUri, null, toast);
    }

    public WnsNotificationResponse pushToast(String channelUri, WnsNotificationRequestOptional optional, WnsToast toast) throws WnsException {
        return this.client.push(this.xmlResourceBuilder, channelUri, (WnsAbstractNotification)toast, this.retryPolicy, optional);
    }

    public List<WnsNotificationResponse> pushToast(List<String> channelUris, WnsToast toast) throws WnsException {
        return this.pushToast(channelUris, null, toast);
    }

    public List<WnsNotificationResponse> pushToast(List<String> channelUris, WnsNotificationRequestOptional optional, WnsToast toast) throws WnsException {
        return this.client.push(this.xmlResourceBuilder, channelUris, (WnsAbstractNotification)toast, this.retryPolicy, optional);
    }

    public WnsNotificationResponse pushBadge(String channelUri, WnsBadge badge) throws WnsException {
        return this.pushBadge(channelUri, null, badge);
    }

    public WnsNotificationResponse pushBadge(String channelUri, WnsNotificationRequestOptional optional, WnsBadge badge) throws WnsException {
        return this.client.push(this.xmlResourceBuilder, channelUri, (WnsAbstractNotification)badge, this.retryPolicy, optional);
    }

    public List<WnsNotificationResponse> pushBadge(List<String> channelUris, WnsBadge badge) throws WnsException {
        return this.pushBadge(channelUris, null, badge);
    }

    public List<WnsNotificationResponse> pushBadge(List<String> channelUris, WnsNotificationRequestOptional optional, WnsBadge badge) throws WnsException {
        return this.client.push(this.xmlResourceBuilder, channelUris, (WnsAbstractNotification)badge, this.retryPolicy, optional);
    }

    public WnsNotificationResponse pushRaw(String channelUri, WnsRaw raw) throws WnsException {
        return this.pushRaw(channelUri, null, raw);
    }

    public WnsNotificationResponse pushRaw(String channelUri, WnsNotificationRequestOptional optional, WnsRaw raw) throws WnsException {
        return this.client.push(this.rawResourceBuilder, channelUri, (WnsAbstractNotification)raw, this.retryPolicy, optional);
    }

    public List<WnsNotificationResponse> pushRaw(List<String> channelUris, WnsRaw raw) throws WnsException {
        return this.pushRaw(channelUris, null, raw);
    }

    public List<WnsNotificationResponse> pushRaw(List<String> channelUris, WnsNotificationRequestOptional optional, WnsRaw raw) throws WnsException {
        return this.client.push(this.rawResourceBuilder, channelUris, (WnsAbstractNotification)raw, this.retryPolicy, optional);
    }
}

