/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.mpns.internal;

import com.notnoop.mpns.MpnsNotification;
import com.notnoop.mpns.MpnsService;
import com.notnoop.mpns.exceptions.NetworkIOException;
import com.notnoop.mpns.internal.Utilities;
import java.util.Collection;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMpnsService
implements MpnsService {
    protected HttpPost postMessage(String subscriptionUri, byte[] requestBody, Collection<? extends Map.Entry<String, String>> headers) {
        HttpPost method = new HttpPost(subscriptionUri);
        method.setEntity((HttpEntity)new ByteArrayEntity(requestBody));
        for (Map.Entry<String, String> entry : headers) {
            method.addHeader(entry.getKey(), entry.getValue());
        }
        return method;
    }

    protected abstract void push(HttpPost var1, MpnsNotification var2);

    @Override
    public void push(String subscriptionUri, String payload, Collection<? extends Map.Entry<String, String>> headers) throws NetworkIOException {
        this.push(this.postMessage(subscriptionUri, Utilities.toUTF8(payload), headers), null);
    }

    @Override
    public void push(String subscriptionUri, MpnsNotification message) throws NetworkIOException {
        this.push(this.postMessage(subscriptionUri, message.getRequestBody(), message.getHttpHeaders()), message);
    }

    protected String getSubscriptionUri(HttpPost request) {
        return request.getURI().toString();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

