/*
 * Decompiled with CFR 0.152.
 */
package edazdarevic.commons.net;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public final class CIDRUtils {
    private static final int ADDRSIZE_V4 = 4;
    private static final int ADDRSIZE_V6 = 16;
    private static final int MAXPREFIX_V4 = 32;
    private static final int MAXPREFIX_V6 = 128;
    private static final String ILLEGAL_ARGUMENT_MSG = "Not a valid CIDR format!";
    private static final String INVALID_EMPTY_ADDR = "Invalid empty address!";
    private static final String INVALID_ADDR = "Invalid address!";
    private InetAddress inetAddress;
    private InetAddress startAddress;
    private InetAddress endAddress;
    private final int prefixLength;

    private static boolean isValidV4(@Nonnull String addr) {
        String[] parts = addr.split("\\.", -1);
        if (parts.length != 4) {
            return false;
        }
        try {
            for (String part : parts) {
                int val = Integer.parseInt(part);
                if (val >= 0 && val <= 255) continue;
                return false;
            }
        }
        catch (NumberFormatException x) {
            return false;
        }
        return true;
    }

    private static boolean isValidV6(String addr) {
        if (addr.length() < 2) {
            return false;
        }
        char[] ca = addr.toCharArray();
        int calen = ca.length;
        int i = 0;
        if (ca[i] == ':' && ca[++i] != ':') {
            return false;
        }
        int curtok = i;
        int colonp = -1;
        boolean saw_xdigit = false;
        int val = 0;
        int sp = 0;
        while (i < calen) {
            char ch;
            int chval;
            if ((chval = Character.digit(ch = ca[i++], 16)) != -1) {
                val <<= 4;
                if ((val |= chval) > 65535) {
                    return false;
                }
                saw_xdigit = true;
                continue;
            }
            if (ch == ':') {
                curtok = i;
                if (!saw_xdigit) {
                    if (colonp != -1) {
                        return false;
                    }
                    colonp = sp;
                    continue;
                }
                if (i == calen) {
                    return false;
                }
                if (sp + 2 > 16) {
                    return false;
                }
                sp += 2;
                saw_xdigit = false;
                val = 0;
                continue;
            }
            if (ch == '.' && sp + 4 <= 16) {
                if (!CIDRUtils.isValidV4(addr.substring(curtok, calen))) {
                    return false;
                }
                sp += 4;
                saw_xdigit = false;
                break;
            }
            return false;
        }
        if (saw_xdigit) {
            if (sp + 2 > 16) {
                return false;
            }
            sp += 2;
        }
        if (colonp != -1) {
            if (sp == 16) {
                return false;
            }
            sp = 16;
        }
        return sp == 16;
    }

    public static void validateIpAddress(String addr) throws UnknownHostException {
        if (addr.isEmpty()) {
            throw new UnknownHostException(INVALID_EMPTY_ADDR);
        }
        if (!CIDRUtils.isValidV4(addr) && !CIDRUtils.isValidV6(addr)) {
            throw new UnknownHostException(INVALID_ADDR);
        }
    }

    public CIDRUtils(@Nonnull String cidr) throws UnknownHostException {
        if (cidr.contains("/")) {
            int index = cidr.indexOf("/");
            String addressPart = cidr.substring(0, index);
            String networkPart = cidr.substring(index + 1);
            CIDRUtils.validateIpAddress(addressPart);
            this.inetAddress = InetAddress.getByName(addressPart);
            this.prefixLength = Integer.parseInt(networkPart);
            if (this.prefixLength < 1 || this.prefixLength > 128 || this.prefixLength > 32 && this.inetAddress.getAddress().length == 4) {
                throw new IllegalArgumentException(ILLEGAL_ARGUMENT_MSG);
            }
        } else {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_MSG);
        }
        this.calculate();
    }

    private void calculate() throws UnknownHostException {
        int targetSize;
        ByteBuffer maskBuffer;
        if (this.inetAddress.getAddress().length == 4) {
            maskBuffer = ByteBuffer.allocate(4).putInt(-1);
            targetSize = 4;
        } else {
            maskBuffer = ByteBuffer.allocate(16).putLong(-1L).putLong(-1L);
            targetSize = 16;
        }
        BigInteger mask = new BigInteger(1, maskBuffer.array()).not().shiftRight(this.prefixLength);
        ByteBuffer buffer = ByteBuffer.wrap(this.inetAddress.getAddress());
        BigInteger ipVal = new BigInteger(1, buffer.array());
        BigInteger startIp = ipVal.and(mask);
        BigInteger endIp = startIp.add(mask.not());
        byte[] startIpArr = this.toBytes(startIp.toByteArray(), targetSize);
        byte[] endIpArr = this.toBytes(endIp.toByteArray(), targetSize);
        this.startAddress = InetAddress.getByAddress(startIpArr);
        this.endAddress = InetAddress.getByAddress(endIpArr);
    }

    private byte[] toBytes(byte[] array, int targetSize) {
        ArrayList<Byte> newArr = new ArrayList<Byte>();
        for (int counter = 0; counter < targetSize && array.length - 1 - counter >= 0; ++counter) {
            newArr.add(0, array[array.length - 1 - counter]);
        }
        int size = newArr.size();
        for (int i = 0; i < targetSize - size; ++i) {
            newArr.add(0, (byte)0);
        }
        byte[] ret = new byte[newArr.size()];
        for (int i = 0; i < newArr.size(); ++i) {
            ret[i] = (Byte)newArr.get(i);
        }
        return ret;
    }

    @Nonnull
    public String getNetworkAddress() {
        return this.startAddress.getHostAddress();
    }

    @Nonnull
    public String getBroadcastAddress() {
        return this.endAddress.getHostAddress();
    }

    private boolean isInRange(@Nonnull String ipAddress, boolean broadcastOk) throws UnknownHostException {
        CIDRUtils.validateIpAddress(ipAddress);
        InetAddress address = InetAddress.getByName(ipAddress);
        BigInteger start = new BigInteger(1, this.startAddress.getAddress());
        BigInteger end = new BigInteger(1, this.endAddress.getAddress());
        BigInteger target = new BigInteger(1, address.getAddress());
        int st = start.compareTo(target);
        int te = target.compareTo(end);
        return (st == -1 || st == 0) && (te == -1 || te == 0 && broadcastOk);
    }

    public boolean isInRange(@Nonnull String ipAddress) throws UnknownHostException {
        return this.isInRange(ipAddress, true);
    }

    public boolean isInHostsRange(@Nonnull String ipAddress) throws UnknownHostException {
        return this.isInRange(ipAddress, false);
    }
}

