/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.annotation.SuppressLint;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.os.Build;
import android.util.Log;
import com.felhr.usbserial.SerialInputStream;
import com.felhr.usbserial.SerialOutputStream;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSerialInterface;
import com.felhr.utils.SafeUsbRequest;
import java.util.Arrays;

public class FTDISerialDevice
extends UsbSerialDevice {
    private static final String CLASS_ID = FTDISerialDevice.class.getSimpleName();
    private static final int FTDI_SIO_RESET = 0;
    private static final int FTDI_SIO_MODEM_CTRL = 1;
    private static final int FTDI_SIO_SET_FLOW_CTRL = 2;
    private static final int FTDI_SIO_SET_BAUD_RATE = 3;
    private static final int FTDI_SIO_SET_DATA = 4;
    private static final int FTDI_REQTYPE_HOST2DEVICE = 64;
    private static final int FTDI_SIO_SET_DTR_MASK = 1;
    private static final int FTDI_SIO_SET_DTR_HIGH = 257;
    private static final int FTDI_SIO_SET_DTR_LOW = 256;
    private static final int FTDI_SIO_SET_RTS_MASK = 2;
    private static final int FTDI_SIO_SET_RTS_HIGH = 514;
    private static final int FTDI_SIO_SET_RTS_LOW = 512;
    private static final int FTDI_SIO_SET_BREAK_ON = 16384;
    private static final int FTDI_SIO_SET_BREAK_OFF = 0;
    public static final int FTDI_BAUDRATE_300 = 10000;
    public static final int FTDI_BAUDRATE_600 = 5000;
    public static final int FTDI_BAUDRATE_1200 = 2500;
    public static final int FTDI_BAUDRATE_2400 = 1250;
    public static final int FTDI_BAUDRATE_4800 = 625;
    public static final int FTDI_BAUDRATE_9600 = 16696;
    public static final int FTDI_BAUDRATE_19200 = 32924;
    public static final int FTDI_BAUDRATE_38400 = 49230;
    public static final int FTDI_BAUDRATE_57600 = 52;
    public static final int FTDI_BAUDRATE_115200 = 26;
    public static final int FTDI_BAUDRATE_230400 = 13;
    public static final int FTDI_BAUDRATE_460800 = 16390;
    public static final int FTDI_BAUDRATE_921600 = 32771;
    private static final int FTDI_SET_DATA_DEFAULT = 8;
    private static final int FTDI_SET_MODEM_CTRL_DEFAULT1 = 257;
    private static final int FTDI_SET_MODEM_CTRL_DEFAULT2 = 514;
    private static final int FTDI_SET_MODEM_CTRL_DEFAULT3 = 256;
    private static final int FTDI_SET_MODEM_CTRL_DEFAULT4 = 512;
    private static final int FTDI_SET_FLOW_CTRL_DEFAULT = 0;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private int currentSioSetData = 0;
    private boolean rtsCtsEnabled = false;
    private boolean dtrDsrEnabled = false;
    private boolean ctsState = true;
    private boolean dsrState = true;
    private boolean firstTime = true;
    private UsbSerialInterface.UsbCTSCallback ctsCallback;
    private UsbSerialInterface.UsbDSRCallback dsrCallback;
    private final UsbInterface mInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    public FTDIUtilities ftdiUtilities = new FTDIUtilities();
    private UsbSerialInterface.UsbParityCallback parityCallback;
    private UsbSerialInterface.UsbFrameCallback frameCallback;
    private UsbSerialInterface.UsbOverrunCallback overrunCallback;
    private UsbSerialInterface.UsbBreakCallback breakCallback;
    private static final byte[] skip = new byte[2];

    public FTDISerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        this(device, connection, -1);
    }

    public FTDISerialDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        super(device, connection);
        this.mInterface = device.getInterface(iface >= 0 ? iface : 0);
    }

    @Override
    public boolean open() {
        boolean ret = this.openFTDI();
        if (ret) {
            SafeUsbRequest requestIN = new SafeUsbRequest();
            requestIN.initialize(this.connection, this.inEndpoint);
            this.restartWorkingThread();
            this.restartWriteThread();
            this.setThreadsParams(requestIN, this.outEndpoint);
            this.asyncMode = true;
            this.isOpen = true;
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void close() {
        this.setControlCommand(1, 256, 0);
        this.setControlCommand(1, 512, 0);
        this.currentSioSetData = 0;
        this.killWorkingThread();
        this.killWriteThread();
        this.connection.releaseInterface(this.mInterface);
        this.isOpen = false;
    }

    @Override
    public boolean syncOpen() {
        boolean ret = this.openFTDI();
        if (ret) {
            this.setSyncParams(this.inEndpoint, this.outEndpoint);
            this.asyncMode = false;
            this.inputStream = new SerialInputStream(this);
            this.outputStream = new SerialOutputStream(this);
            this.isOpen = true;
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void syncClose() {
        this.setControlCommand(1, 256, 0);
        this.setControlCommand(1, 512, 0);
        this.currentSioSetData = 0;
        this.connection.releaseInterface(this.mInterface);
        this.isOpen = false;
    }

    @Override
    public void setBaudRate(int baudRate) {
        short[] encodedBaudRate = this.encodedBaudRate(baudRate);
        if (encodedBaudRate != null) {
            this.setEncodedBaudRate(encodedBaudRate);
        } else {
            this.setOldBaudRate(baudRate);
        }
    }

    @Override
    public void setDataBits(int dataBits) {
        switch (dataBits) {
            case 5: {
                this.currentSioSetData |= 1;
                this.currentSioSetData &= 0xFFFFFFFD;
                this.currentSioSetData |= 4;
                this.currentSioSetData &= 0xFFFFFFF7;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            case 6: {
                this.currentSioSetData &= 0xFFFFFFFE;
                this.currentSioSetData |= 2;
                this.currentSioSetData |= 4;
                this.currentSioSetData &= 0xFFFFFFF7;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            case 7: {
                this.currentSioSetData |= 1;
                this.currentSioSetData |= 2;
                this.currentSioSetData |= 4;
                this.currentSioSetData &= 0xFFFFFFF7;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            case 8: {
                this.currentSioSetData &= 0xFFFFFFFE;
                this.currentSioSetData &= 0xFFFFFFFD;
                this.currentSioSetData &= 0xFFFFFFFB;
                this.currentSioSetData |= 8;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            default: {
                this.currentSioSetData &= 0xFFFFFFFE;
                this.currentSioSetData &= 0xFFFFFFFD;
                this.currentSioSetData &= 0xFFFFFFFB;
                this.currentSioSetData |= 8;
                this.setControlCommand(4, this.currentSioSetData, 0);
            }
        }
    }

    @Override
    public void setStopBits(int stopBits) {
        switch (stopBits) {
            case 1: {
                this.currentSioSetData &= 0xFFFFF7FF;
                this.currentSioSetData &= 0xFFFFEFFF;
                this.currentSioSetData &= 0xFFFFDFFF;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            case 3: {
                this.currentSioSetData |= 0x800;
                this.currentSioSetData &= 0xFFFFEFFF;
                this.currentSioSetData &= 0xFFFFDFFF;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            case 2: {
                this.currentSioSetData &= 0xFFFFF7FF;
                this.currentSioSetData |= 0x1000;
                this.currentSioSetData &= 0xFFFFDFFF;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            default: {
                this.currentSioSetData &= 0xFFFFF7FF;
                this.currentSioSetData &= 0xFFFFEFFF;
                this.currentSioSetData &= 0xFFFFDFFF;
                this.setControlCommand(4, this.currentSioSetData, 0);
            }
        }
    }

    @Override
    public void setParity(int parity) {
        switch (parity) {
            case 0: {
                this.currentSioSetData &= 0xFFFFFEFF;
                this.currentSioSetData &= 0xFFFFFDFF;
                this.currentSioSetData &= 0xFFFFFBFF;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            case 1: {
                this.currentSioSetData |= 0x100;
                this.currentSioSetData &= 0xFFFFFDFF;
                this.currentSioSetData &= 0xFFFFFBFF;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            case 2: {
                this.currentSioSetData &= 0xFFFFFEFF;
                this.currentSioSetData |= 0x200;
                this.currentSioSetData &= 0xFFFFFBFF;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            case 3: {
                this.currentSioSetData |= 0x100;
                this.currentSioSetData |= 0x200;
                this.currentSioSetData &= 0xFFFFFBFF;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            case 4: {
                this.currentSioSetData &= 0xFFFFFEFF;
                this.currentSioSetData &= 0xFFFFFDFF;
                this.currentSioSetData |= 0x400;
                this.setControlCommand(4, this.currentSioSetData, 0);
                break;
            }
            default: {
                this.currentSioSetData &= 0xFFFFFEFF;
                this.currentSioSetData &= 0xFFFFFDFF;
                this.currentSioSetData &= 0xFFFFFBFF;
                this.setControlCommand(4, this.currentSioSetData, 0);
            }
        }
    }

    @Override
    public void setFlowControl(int flowControl) {
        switch (flowControl) {
            case 0: {
                this.setControlCommand(2, 0, 0);
                this.rtsCtsEnabled = false;
                this.dtrDsrEnabled = false;
                break;
            }
            case 1: {
                this.rtsCtsEnabled = true;
                this.dtrDsrEnabled = false;
                int indexRTSCTS = 1;
                this.setControlCommand(2, 0, indexRTSCTS);
                break;
            }
            case 2: {
                this.dtrDsrEnabled = true;
                this.rtsCtsEnabled = false;
                int indexDSRDTR = 2;
                this.setControlCommand(2, 0, indexDSRDTR);
                break;
            }
            case 3: {
                int indexXONXOFF = 4;
                int wValue = 4881;
                this.setControlCommand(2, wValue, indexXONXOFF);
                break;
            }
            default: {
                this.setControlCommand(2, 0, 0);
            }
        }
    }

    @Override
    public void setBreak(boolean state) {
        this.currentSioSetData = state ? (this.currentSioSetData |= 0x4000) : (this.currentSioSetData &= 0xFFFFBFFF);
        this.setControlCommand(4, this.currentSioSetData, 0);
    }

    @Override
    public void setRTS(boolean state) {
        if (state) {
            this.setControlCommand(1, 514, 0);
        } else {
            this.setControlCommand(1, 512, 0);
        }
    }

    @Override
    public void setDTR(boolean state) {
        if (state) {
            this.setControlCommand(1, 257, 0);
        } else {
            this.setControlCommand(1, 256, 0);
        }
    }

    @Override
    public void getCTS(UsbSerialInterface.UsbCTSCallback ctsCallback) {
        this.ctsCallback = ctsCallback;
    }

    @Override
    public void getDSR(UsbSerialInterface.UsbDSRCallback dsrCallback) {
        this.dsrCallback = dsrCallback;
    }

    @Override
    public void getBreak(UsbSerialInterface.UsbBreakCallback breakCallback) {
        this.breakCallback = breakCallback;
    }

    @Override
    public void getFrame(UsbSerialInterface.UsbFrameCallback frameCallback) {
        this.frameCallback = frameCallback;
    }

    @Override
    public void getOverrun(UsbSerialInterface.UsbOverrunCallback overrunCallback) {
        this.overrunCallback = overrunCallback;
    }

    @Override
    public void getParity(UsbSerialInterface.UsbParityCallback parityCallback) {
        this.parityCallback = parityCallback;
    }

    private boolean openFTDI() {
        if (!this.connection.claimInterface(this.mInterface, true)) {
            Log.i((String)CLASS_ID, (String)"Interface could not be claimed");
            return false;
        }
        Log.i((String)CLASS_ID, (String)"Interface succesfully claimed");
        int numberEndpoints = this.mInterface.getEndpointCount();
        for (int i = 0; i <= numberEndpoints - 1; ++i) {
            UsbEndpoint endpoint = this.mInterface.getEndpoint(i);
            if (endpoint.getType() == 2 && endpoint.getDirection() == 128) {
                this.inEndpoint = endpoint;
                continue;
            }
            this.outEndpoint = endpoint;
        }
        this.firstTime = true;
        if (this.setControlCommand(0, 0, 0) < 0) {
            return false;
        }
        if (this.setControlCommand(4, 8, 0) < 0) {
            return false;
        }
        this.currentSioSetData = 8;
        if (this.setControlCommand(1, 257, 0) < 0) {
            return false;
        }
        if (this.setControlCommand(1, 514, 0) < 0) {
            return false;
        }
        if (this.setControlCommand(2, 0, 0) < 0) {
            return false;
        }
        if (this.setControlCommand(3, 16696, 0) < 0) {
            return false;
        }
        this.rtsCtsEnabled = false;
        this.dtrDsrEnabled = false;
        return true;
    }

    private int setControlCommand(int request, int value, int index) {
        int dataLength = 0;
        int response = this.connection.controlTransfer(64, request, value, this.mInterface.getId() + 1 + index, null, dataLength, 0);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return response;
    }

    static byte[] adaptArray(byte[] ftdiData) {
        int length = ftdiData.length;
        if (length > 64) {
            int n = 1;
            int p = 64;
            while (p < length) {
                p = ++n * 64;
            }
            int realLength = length - n * 2;
            byte[] data = new byte[realLength];
            FTDISerialDevice.copyData(ftdiData, data);
            return data;
        }
        if (length == 2) {
            return EMPTY_BYTE_ARRAY;
        }
        return Arrays.copyOfRange(ftdiData, 2, length);
    }

    private static void copyData(byte[] src, byte[] dst) {
        int srcPos = 2;
        int dstPos = 0;
        while (srcPos - 2 <= src.length - 64) {
            System.arraycopy(src, srcPos, dst, dstPos, 62);
            srcPos += 64;
            dstPos += 62;
        }
        int remaining = src.length - srcPos + 2;
        if (remaining > 0) {
            System.arraycopy(src, srcPos, dst, dstPos, remaining - 2);
        }
    }

    @Override
    public int syncRead(byte[] buffer, int timeout) {
        long beginTime = System.currentTimeMillis();
        long stopTime = beginTime + (long)timeout;
        if (this.asyncMode) {
            return -1;
        }
        if (buffer == null) {
            return 0;
        }
        int n = buffer.length / 62;
        if (buffer.length % 62 != 0) {
            ++n;
        }
        byte[] tempBuffer = new byte[buffer.length + n * 2];
        int readen = 0;
        do {
            int timeLeft = 0;
            if (timeout > 0 && (timeLeft = (int)(stopTime - System.currentTimeMillis())) <= 0) break;
            int numberBytes = this.connection.bulkTransfer(this.inEndpoint, tempBuffer, tempBuffer.length, timeLeft);
            if (numberBytes <= 2) continue;
            byte[] newBuffer = this.ftdiUtilities.adaptArray(tempBuffer);
            System.arraycopy(newBuffer, 0, buffer, 0, buffer.length);
            int p = numberBytes / 64;
            if (numberBytes % 64 != 0) {
                ++p;
            }
            readen = numberBytes - p * 2;
        } while (readen <= 0);
        return readen;
    }

    @Override
    public int syncRead(byte[] buffer, int offset, int length, int timeout) {
        long beginTime = System.currentTimeMillis();
        long stopTime = beginTime + (long)timeout;
        if (this.asyncMode) {
            return -1;
        }
        if (buffer == null) {
            return 0;
        }
        int n = length / 62;
        if (length % 62 != 0) {
            ++n;
        }
        byte[] tempBuffer = new byte[length + n * 2];
        int readen = 0;
        do {
            int timeLeft = 0;
            if (timeout > 0 && (timeLeft = (int)(stopTime - System.currentTimeMillis())) <= 0) break;
            int numberBytes = this.connection.bulkTransfer(this.inEndpoint, tempBuffer, tempBuffer.length, timeLeft);
            if (numberBytes <= 2) continue;
            byte[] newBuffer = this.ftdiUtilities.adaptArray(tempBuffer);
            System.arraycopy(newBuffer, 0, buffer, offset, length);
            int p = numberBytes / 64;
            if (numberBytes % 64 != 0) {
                ++p;
            }
            readen = numberBytes - p * 2;
        } while (readen <= 0);
        return readen;
    }

    @SuppressLint(value={"NewApi"})
    private int readSyncJelly(byte[] buffer, int timeout, long stopTime) {
        int read = 0;
        do {
            int timeLeft = 0;
            if (timeout > 0 && (timeLeft = (int)(stopTime - System.currentTimeMillis())) <= 0) break;
            int numberBytes = this.connection.bulkTransfer(this.inEndpoint, skip, skip.length, timeLeft);
            if (numberBytes <= 2) continue;
            numberBytes = this.connection.bulkTransfer(this.inEndpoint, buffer, read, 62, timeLeft);
            read += numberBytes;
        } while (read <= 0);
        return read;
    }

    private short getBcdDevice() {
        if (Build.VERSION.SDK_INT >= 13) {
            byte[] descriptors = this.connection.getRawDescriptors();
            return (short)((descriptors[12] << 8) + descriptors[13]);
        }
        return -1;
    }

    private byte getISerialNumber() {
        if (Build.VERSION.SDK_INT >= 13) {
            byte[] descriptors = this.connection.getRawDescriptors();
            return descriptors[16];
        }
        return -1;
    }

    private boolean isBaudTolerated(long speed, long target) {
        return speed >= target * 100L / 103L && speed <= target * 100L / 97L;
    }

    private short[] encodedBaudRate(int baudRate) {
        int fastClk;
        int clk;
        boolean isFT232A = false;
        boolean clk12MHz = false;
        boolean hIndex = false;
        short[] ret = new short[2];
        byte[] encodedFraction = new byte[]{0, 3, 2, 4, 1, 5, 6, 7};
        byte[] roundoff232a = new byte[]{0, 1, 0, 1, 0, -1, 2, 1, 0, -1, -2, -3, 4, 3, 2, 1};
        short bcdDevice = this.getBcdDevice();
        if (bcdDevice == -1) {
            return null;
        }
        if (bcdDevice == 512 && this.getISerialNumber() == 0) {
            isFT232A = true;
        }
        if (bcdDevice == 1280 || bcdDevice == 1792 || bcdDevice == 2048 || bcdDevice == 2304 || bcdDevice == 4096) {
            hIndex = true;
        }
        if (bcdDevice == 1792 || bcdDevice == 2048 || bcdDevice == 2304) {
            clk12MHz = true;
        }
        if (baudRate >= 1200 && clk12MHz) {
            clk = 12000000;
            fastClk = 131072;
        } else {
            clk = 3000000;
            fastClk = 0;
        }
        if (baudRate < clk >> 14 || baudRate > clk) {
            return null;
        }
        int divisor = (clk << 4) / baudRate;
        divisor = (divisor & 0xF) == 1 ? (divisor &= 0xFFFFFFF8) : (isFT232A ? (divisor += roundoff232a[divisor & 0xF]) : ++divisor);
        int hwSpeed = (clk << 3) / (divisor >>= 1);
        if (!this.isBaudTolerated(hwSpeed, baudRate)) {
            return null;
        }
        int frac = divisor & 7;
        if ((divisor >>= 3) == 1) {
            if (frac == 0) {
                divisor = 0;
            } else {
                frac = 0;
            }
        }
        ret[0] = (short)(divisor |= encodedFraction[frac] << 14 | fastClk);
        ret[1] = (short)(divisor >> 16);
        if (hIndex) {
            ret[1] = (short)(ret[1] << 8);
        }
        return ret;
    }

    private void setEncodedBaudRate(short[] encodedBaudRate) {
        this.connection.controlTransfer(64, 3, (int)encodedBaudRate[0], (int)encodedBaudRate[1], null, 0, 0);
    }

    private void setOldBaudRate(int baudRate) {
        int value = 0;
        value = baudRate >= 0 && baudRate <= 300 ? 10000 : (baudRate > 300 && baudRate <= 600 ? 5000 : (baudRate > 600 && baudRate <= 1200 ? 2500 : (baudRate > 1200 && baudRate <= 2400 ? 1250 : (baudRate > 2400 && baudRate <= 4800 ? 625 : (baudRate > 4800 && baudRate <= 9600 ? 16696 : (baudRate > 9600 && baudRate <= 19200 ? 32924 : (baudRate > 19200 && baudRate <= 38400 ? 49230 : (baudRate > 19200 && baudRate <= 57600 ? 52 : (baudRate > 57600 && baudRate <= 115200 ? 26 : (baudRate > 115200 && baudRate <= 230400 ? 13 : (baudRate > 230400 && baudRate <= 460800 ? 16390 : (baudRate > 460800 && baudRate <= 921600 ? 32771 : (baudRate > 921600 ? 32771 : 16696)))))))))))));
        this.setControlCommand(3, value, 0);
    }

    public class FTDIUtilities {
        public byte[] adaptArray(byte[] ftdiData) {
            int length = ftdiData.length;
            if (length > 64) {
                int n = 1;
                int p = 64;
                while (p < length) {
                    p = ++n * 64;
                }
                int realLength = length - n * 2;
                byte[] data = new byte[realLength];
                FTDISerialDevice.copyData(ftdiData, data);
                return data;
            }
            return Arrays.copyOfRange(ftdiData, 2, length);
        }

        public void checkModemStatus(byte[] data) {
            boolean dsr;
            if (data.length == 0) {
                return;
            }
            boolean cts = (data[0] & 0x10) == 16;
            boolean bl = dsr = (data[0] & 0x20) == 32;
            if (FTDISerialDevice.this.firstTime) {
                FTDISerialDevice.this.ctsState = cts;
                FTDISerialDevice.this.dsrState = dsr;
                if (FTDISerialDevice.this.rtsCtsEnabled && FTDISerialDevice.this.ctsCallback != null) {
                    FTDISerialDevice.this.ctsCallback.onCTSChanged(FTDISerialDevice.this.ctsState);
                }
                if (FTDISerialDevice.this.dtrDsrEnabled && FTDISerialDevice.this.dsrCallback != null) {
                    FTDISerialDevice.this.dsrCallback.onDSRChanged(FTDISerialDevice.this.dsrState);
                }
                FTDISerialDevice.this.firstTime = false;
                return;
            }
            if (FTDISerialDevice.this.rtsCtsEnabled && cts != FTDISerialDevice.this.ctsState && FTDISerialDevice.this.ctsCallback != null) {
                FTDISerialDevice.this.ctsState = !FTDISerialDevice.this.ctsState;
                FTDISerialDevice.this.ctsCallback.onCTSChanged(FTDISerialDevice.this.ctsState);
            }
            if (FTDISerialDevice.this.dtrDsrEnabled && dsr != FTDISerialDevice.this.dsrState && FTDISerialDevice.this.dsrCallback != null) {
                FTDISerialDevice.this.dsrState = !FTDISerialDevice.this.dsrState;
                FTDISerialDevice.this.dsrCallback.onDSRChanged(FTDISerialDevice.this.dsrState);
            }
            if (FTDISerialDevice.this.parityCallback != null && (data[1] & 4) == 4) {
                FTDISerialDevice.this.parityCallback.onParityError();
            }
            if (FTDISerialDevice.this.frameCallback != null && (data[1] & 8) == 8) {
                FTDISerialDevice.this.frameCallback.onFramingError();
            }
            if (FTDISerialDevice.this.overrunCallback != null && (data[1] & 2) == 2) {
                FTDISerialDevice.this.overrunCallback.onOverrunError();
            }
            if (FTDISerialDevice.this.breakCallback != null && (data[1] & 0x10) == 16) {
                FTDISerialDevice.this.breakCallback.onBreakInterrupt();
            }
        }
    }
}

