/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import com.felhr.usbserial.UsbSerialInterface;
import java.io.IOException;
import java.io.InputStream;

public class SerialInputStream
extends InputStream {
    private int timeout = 0;
    private int maxBufferSize = 16384;
    private final byte[] buffer;
    private int pointer;
    private int bufferSize;
    protected final UsbSerialInterface device;

    public SerialInputStream(UsbSerialInterface device) {
        this.device = device;
        this.buffer = new byte[this.maxBufferSize];
        this.pointer = 0;
        this.bufferSize = -1;
    }

    public SerialInputStream(UsbSerialInterface device, int maxBufferSize) {
        this.device = device;
        this.maxBufferSize = maxBufferSize;
        this.buffer = new byte[this.maxBufferSize];
        this.pointer = 0;
        this.bufferSize = -1;
    }

    @Override
    public int read() {
        int value = this.checkFromBuffer();
        if (value >= 0) {
            return value;
        }
        int ret = this.device.syncRead(this.buffer, this.timeout);
        if (ret >= 0) {
            this.bufferSize = ret;
            return this.buffer[this.pointer++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) {
        return this.device.syncRead(b, this.timeout);
    }

    @Override
    public int available() throws IOException {
        if (this.bufferSize > 0) {
            return this.bufferSize - this.pointer;
        }
        return 0;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private int checkFromBuffer() {
        if (this.bufferSize > 0 && this.pointer < this.bufferSize) {
            return this.buffer[this.pointer++] & 0xFF;
        }
        this.pointer = 0;
        this.bufferSize = -1;
        return -1;
    }
}

