/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.utils;

import com.annimon.stream.IntStream;
import com.annimon.stream.function.IntPredicate;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProtocolBuffer {
    public static final String BINARY = "binary";
    public static final String TEXT = "text";
    private String mode;
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private byte[] rawBuffer;
    private int bufferPointer = 0;
    private byte[] separator;
    private String delimiter;
    private StringBuilder stringBuffer;
    private List<String> commands = new ArrayList<String>();
    private List<byte[]> rawCommands = new ArrayList<byte[]>();

    public ProtocolBuffer(String mode) {
        this.mode = mode;
        if (mode.equals(BINARY)) {
            this.rawBuffer = new byte[16384];
        } else {
            this.stringBuffer = new StringBuilder(16384);
        }
    }

    public ProtocolBuffer(String mode, int bufferSize) {
        this.mode = mode;
        if (mode.equals(BINARY)) {
            this.rawBuffer = new byte[bufferSize];
        } else {
            this.stringBuffer = new StringBuilder(bufferSize);
        }
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiter(byte[] delimiter) {
        this.separator = delimiter;
    }

    public synchronized void appendData(byte[] data) {
        if (data.length == 0) {
            return;
        }
        if (this.mode.equals(TEXT)) {
            try {
                String tempStr;
                String dataStr = new String(data, "UTF-8");
                this.stringBuffer.append(dataStr);
                String buffer = this.stringBuffer.toString();
                int prevIndex = 0;
                int index = buffer.indexOf(this.delimiter);
                while (index >= 0) {
                    tempStr = buffer.substring(prevIndex, index + this.delimiter.length());
                    this.commands.add(tempStr);
                    prevIndex = index + this.delimiter.length();
                    index = this.stringBuffer.toString().indexOf(this.delimiter, prevIndex);
                }
                if (prevIndex > 0) {
                    tempStr = buffer.substring(prevIndex, buffer.length());
                    this.stringBuffer.setLength(0);
                    this.stringBuffer.append(tempStr);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (this.mode.equals(BINARY)) {
            this.appendRawData(data);
        }
    }

    public boolean hasMoreCommands() {
        if (this.mode.equals(TEXT)) {
            return this.commands.size() > 0;
        }
        return this.rawCommands.size() > 0;
    }

    public String nextTextCommand() {
        if (this.commands.size() > 0) {
            return this.commands.remove(0);
        }
        return null;
    }

    public byte[] nextBinaryCommand() {
        if (this.rawCommands.size() > 0) {
            return this.rawCommands.remove(0);
        }
        return null;
    }

    private void appendRawData(byte[] rawData) {
        System.arraycopy(rawData, 0, this.rawBuffer, this.bufferPointer, rawData.length);
        this.bufferPointer += rawData.length;
        SeparatorPredicate predicate = new SeparatorPredicate();
        int[] indexes = IntStream.range((int)0, (int)this.bufferPointer).filter((IntPredicate)predicate).toArray();
        int prevIndex = 0;
        int[] nArray = indexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            byte[] command = Arrays.copyOfRange(this.rawBuffer, prevIndex, i2 + this.separator.length);
            this.rawCommands.add(command);
            prevIndex = i2 + this.separator.length;
        }
        if (prevIndex < this.rawBuffer.length && prevIndex > 0) {
            byte[] tempBuffer = Arrays.copyOfRange(this.rawBuffer, prevIndex, this.rawBuffer.length);
            this.bufferPointer = 0;
            System.arraycopy(tempBuffer, 0, this.rawBuffer, this.bufferPointer, rawData.length);
            this.bufferPointer += rawData.length;
        }
    }

    private class SeparatorPredicate
    implements IntPredicate {
        private SeparatorPredicate() {
        }

        public boolean test(int value) {
            if (ProtocolBuffer.this.rawBuffer[value] == ProtocolBuffer.this.separator[0]) {
                for (int i = 1; i <= ProtocolBuffer.this.separator.length - 1; ++i) {
                    if (ProtocolBuffer.this.rawBuffer[value + i] == ProtocolBuffer.this.separator[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

