/*
 * Decompiled with CFR 0.152.
 */
package com.github.fatihsokmen.pulltodismiss;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class PullDismissLayout
extends FrameLayout {
    private Listener listener;
    private ViewDragHelper dragHelper;
    private float minFlingVelocity;
    private float verticalTouchSlop;
    private boolean animateAlpha;

    public PullDismissLayout(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public PullDismissLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public PullDismissLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    @TargetApi(value=21)
    public PullDismissLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle, int defResStyle) {
        super(context, attrs, defStyle, defResStyle);
        this.init(context);
    }

    private void init(@NonNull Context context) {
        if (!this.isInEditMode()) {
            ViewConfiguration vc = ViewConfiguration.get((Context)context);
            this.minFlingVelocity = vc.getScaledMinimumFlingVelocity();
            this.dragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)new ViewDragCallback(this));
        }
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.dragHelper != null && this.dragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        View child;
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        boolean pullingDown = false;
        switch (action) {
            case 0: {
                this.verticalTouchSlop = event.getY();
            }
            case 2: {
                float dy = event.getY() - this.verticalTouchSlop;
                if (!(dy > (float)this.dragHelper.getTouchSlop())) break;
                pullingDown = true;
                break;
            }
            case 1: 
            case 3: {
                this.verticalTouchSlop = 0.0f;
            }
        }
        if (!this.dragHelper.shouldInterceptTouchEvent(event) && pullingDown && this.dragHelper.getViewDragState() == 0 && this.dragHelper.checkTouchSlop(2) && (child = this.getChildAt(0)) != null && !this.listener.onShouldInterceptTouchEvent()) {
            this.dragHelper.captureChildView(child, event.getPointerId(0));
            return this.dragHelper.getViewDragState() == 1;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.dragHelper.processTouchEvent(event);
        return this.dragHelper.getCapturedView() != null;
    }

    public void setMinFlingVelocity(float velocity) {
        this.minFlingVelocity = velocity;
    }

    public void setAnimateAlpha(boolean b) {
        this.animateAlpha = b;
    }

    public void setListener(Listener l) {
        this.listener = l;
    }

    public static interface Listener {
        public void onDismissed();

        public boolean onShouldInterceptTouchEvent();
    }

    private static class ViewDragCallback
    extends ViewDragHelper.Callback {
        private PullDismissLayout pullDismissLayout;
        private int startTop;
        private float dragPercent;
        private View capturedView;
        private boolean dismissed;

        private ViewDragCallback(PullDismissLayout layout) {
            this.pullDismissLayout = layout;
            this.dragPercent = 0.0f;
            this.dismissed = false;
        }

        public boolean tryCaptureView(View view, int i) {
            return this.capturedView == null;
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return top < 0 ? 0 : top;
        }

        public void onViewCaptured(View view, int activePointerId) {
            this.capturedView = view;
            this.startTop = view.getTop();
            this.dragPercent = 0.0f;
            this.dismissed = false;
        }

        @SuppressLint(value={"NewApi"})
        public void onViewPositionChanged(View view, int left, int top, int dx, int dy) {
            int range = this.pullDismissLayout.getHeight();
            int moved = Math.abs(top - this.startTop);
            if (range > 0) {
                this.dragPercent = (float)moved / (float)range;
            }
            if (this.pullDismissLayout.animateAlpha) {
                view.setAlpha(1.0f - this.dragPercent);
                this.pullDismissLayout.invalidate();
            }
        }

        public void onViewDragStateChanged(int state) {
            if (this.capturedView != null && this.dismissed && state == 0) {
                this.pullDismissLayout.removeView(this.capturedView);
                if (this.pullDismissLayout.listener != null) {
                    this.pullDismissLayout.listener.onDismissed();
                }
            }
        }

        public void onViewReleased(View view, float xv, float yv) {
            this.dismissed = this.dragPercent >= 0.5f || Math.abs(xv) > this.pullDismissLayout.minFlingVelocity && this.dragPercent > 0.2f;
            int finalTop = this.dismissed ? this.pullDismissLayout.getHeight() : this.startTop;
            this.pullDismissLayout.dragHelper.settleCapturedViewAt(0, finalTop);
            this.pullDismissLayout.invalidate();
        }
    }
}

