/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;
import com.github.fastshape.R;
import com.github.fastshape.inter.CompleteInter;
import com.github.fastshape.viewhelper.FirstHelper;
import com.github.fastshape.viewhelper.SetBackgroundUtil;

public class MyLinearLayout
extends LinearLayout {
    private FirstHelper viewHelper;
    private int saveLayerCount;

    public MyLinearLayout(Context context) {
        super(context);
        this.initHelper(null);
    }

    public MyLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initHelper(attrs);
    }

    public MyLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initHelper(attrs);
    }

    private void initHelper(AttributeSet attrs) {
        this.viewHelper = new FirstHelper(new CompleteInter(){

            @Override
            public void complete() {
                MyLinearLayout.this.complete();
            }

            @Override
            public void completeClip() {
                MyLinearLayout.this.completeClip();
            }

            @Override
            public void resetClip() {
                MyLinearLayout.this.resetClip();
            }
        });
        this.init(attrs);
    }

    public FirstHelper getViewHelper() {
        return this.viewHelper;
    }

    public void init(AttributeSet attrs) {
        this.viewHelper.init(this.getContext(), attrs, R.attr.MyLinearLayoutStyle);
        if (this.getBackground() == null) {
            this.complete();
        }
    }

    public void complete() {
        if (this.viewHelper != null) {
            SetBackgroundUtil.viewComplete((View)this, this.viewHelper);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.viewHelper != null && this.viewHelper.getClipSwitch()) {
            this.viewHelper.onSizeChanged();
            this.viewHelper.onRefreshPaint(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom(), this.getWidth(), this.getHeight());
        }
    }

    public void draw(Canvas canvas) {
        if (this.viewHelper != null && this.viewHelper.isClipBg() && this.viewHelper.getClipSwitch()) {
            canvas.save();
            int count = canvas.saveLayer(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), null, 31);
            super.draw(canvas);
            this.viewHelper.clipBg(canvas);
            canvas.restore();
        } else {
            super.draw(canvas);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.viewHelper != null && this.viewHelper.getClipSwitch()) {
            this.saveLayerCount = canvas.saveLayer(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), null, 31);
        }
        super.dispatchDraw(canvas);
        if (this.viewHelper != null && this.viewHelper.getClipSwitch()) {
            this.viewHelper.dispatchDrawEnd(this.saveLayerCount, canvas);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 1 && this.viewHelper != null && this.viewHelper.getClipIsAreaClick() && this.viewHelper.getClipSwitch() && !this.viewHelper.onTouchEvent(ev)) {
            return false;
        }
        return super.dispatchTouchEvent(ev);
    }

    public void completeClip() {
        if (this.viewHelper != null && this.viewHelper.getClipSwitch()) {
            if (this.viewHelper.clipPaint == null) {
                this.viewHelper.onSizeChanged();
            }
            this.viewHelper.onRefreshPaint(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom(), this.getWidth(), this.getHeight());
            this.invalidate();
        }
    }

    public void resetClip() {
        if (this.viewHelper != null) {
            this.viewHelper.clearClipAttr();
            this.invalidate();
        }
    }
}

